/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.model;

import org.exoplatform.social.common.Utils;
import org.exoplatform.social.core.CacheEntry;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;

public class Space
implements CacheEntry {
    private String id;
    private String displayName;
    private String groupId;
    private boolean hasBindings;
    private String app;
    private String parent;
    private String description;
    private String tag;
    private String[] pendingUsers;
    private String[] invitedUsers;
    private String template;
    private String url;
    private String visibility;
    private String registration;
    private String priority;
    private AvatarAttachment avatarAttachment;
    private BannerAttachment bannerAttachment;
    private long createdTime;
    private long cacheTime;
    private long lastUpdatedTime;
    private String prettyName;
    private String avatarUrl;
    private String bannerUrl;
    @Deprecated
    private String creator;
    private String editor;
    private String[] managers;
    private Long avatarLastUpdated;
    private Long bannerLastUpdated;
    private String[] members;
    private String[] redactors;
    public static final String ACTIVE_STATUS = "active";
    public static final String DEACTIVE_STATUS = "deactive";
    public static final String INSTALL_STATUS = "installed";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String HIDDEN = "hidden";
    public static final String OPEN = "open";
    public static final String VALIDATION = "validation";
    public static final String CLOSED = "closed";
    public static final String HIGH_PRIORITY = "1";
    public static final String INTERMEDIATE_PRIORITY = "2";
    public static final String LOW_PRIORITY = "3";
    public static final String CREATOR = "space_creator";
    private UpdatedField field;

    public void setLastUpdatedTime(long lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public UpdatedField getField() {
        return this.field;
    }

    public void setField(UpdatedField field) {
        this.field = field;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setDisplayName(String spaceDisplayName) {
        this.displayName = spaceDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getPrettyName();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setHasBindings(boolean hasBindings) {
        this.hasBindings = hasBindings;
    }

    public boolean hasBindings() {
        return this.hasBindings;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getApp() {
        return this.app;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setPendingUsers(String[] pendingUsers) {
        this.pendingUsers = pendingUsers;
    }

    public String[] getPendingUsers() {
        return this.pendingUsers;
    }

    public void setInvitedUsers(String[] invitedUsers) {
        this.invitedUsers = invitedUsers;
    }

    public String[] getInvitedUsers() {
        return this.invitedUsers;
    }

    @Deprecated
    public void setType(String type) {
        this.template = type;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getType() {
        return this.template;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getShortName() {
        return this.groupId.substring(this.groupId.lastIndexOf("/") + 1);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String toString() {
        return this.displayName + " (" + this.groupId + ")";
    }

    public String getRegistration() {
        return this.registration;
    }

    public void setRegistration(String registration) {
        this.registration = registration;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setAvatarAttachment(AvatarAttachment avatarAttachment) {
        this.avatarAttachment = avatarAttachment;
        if (avatarAttachment != null) {
            this.setAvatarLastUpdated(avatarAttachment.getLastModified());
        } else {
            this.setAvatarLastUpdated(null);
            this.setAvatarUrl(null);
        }
    }

    public AvatarAttachment getAvatarAttachment() {
        return this.avatarAttachment;
    }

    public BannerAttachment getBannerAttachment() {
        return this.bannerAttachment;
    }

    public void setBannerAttachment(BannerAttachment bannerAttachment) {
        this.bannerAttachment = bannerAttachment;
        if (bannerAttachment != null) {
            this.setBannerLastUpdated(bannerAttachment.getLastModified());
        } else {
            this.setBannerLastUpdated(null);
            this.setBannerUrl(null);
        }
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public void setPrettyName(String prettyName) {
        this.prettyName = Utils.cleanString(prettyName);
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getBannerUrl() {
        return this.bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    @Deprecated
    public String getCreator() {
        return this.creator;
    }

    @Deprecated
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getEditor() {
        return this.editor;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public String[] getManagers() {
        return this.managers;
    }

    public void setManagers(String[] managers) {
        this.managers = managers;
    }

    public String[] getMembers() {
        return this.members;
    }

    public void setMembers(String[] members) {
        this.members = members;
    }

    public String[] getRedactors() {
        return this.redactors;
    }

    public void setRedactors(String[] redactors) {
        this.redactors = redactors;
    }

    public Long getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    public void setAvatarLastUpdated(Long avatarLastUpdatedTime) {
        this.avatarLastUpdated = avatarLastUpdatedTime;
    }

    public Long getBannerLastUpdated() {
        return this.bannerLastUpdated;
    }

    public void setBannerLastUpdated(Long bannerLastUpdated) {
        this.bannerLastUpdated = bannerLastUpdated;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime != null ? createdTime : System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Space other = (Space)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public long getCacheTime() {
        return this.cacheTime;
    }

    @Override
    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public static enum UpdatedField {
        DESCRIPTION(true);

        private boolean type;

        private UpdatedField(boolean type) {
            this.type = type;
        }

        public boolean value() {
            return this.type;
        }
    }
}

