/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.automatic.translation.impl.connectors;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.exoplatform.automatic.translation.api.AutomaticTranslationComponentPlugin;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONObject;

public class GoogleTranslateConnector
extends AutomaticTranslationComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(GoogleTranslateConnector.class);
    private static final String GOOGLE_TRANSLATE_SERVICE = "google-translate";
    private static final String API_URL = "https://translation.googleapis.com/language/translate/v2";
    private static final String KEY_PARAM = "key";
    private static final String DATA_PATTERN = "{'q': '{message}', 'target': '{targetLocale}'}";
    private static final int DEFAULT_POOL_CONNECTION = 100;
    private static final String ERROR = "error";
    private HttpClient httpClient;

    public GoogleTranslateConnector(SettingService settingService) {
        super(settingService);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(100);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setMaxConnPerRoute(100);
        this.httpClient = httpClientBuilder.build();
    }

    public String translate(String message, Locale targetLocale) {
        long startTime = System.currentTimeMillis();
        String serviceUrl = "https://translation.googleapis.com/language/translate/v2?key=" + this.getApiKey();
        String data = DATA_PATTERN.replace("{message}", message).replace("{targetLocale}", targetLocale.getLanguage());
        try {
            HttpPost httpTypeRequest = new HttpPost(serviceUrl);
            httpTypeRequest.setEntity((HttpEntity)new StringEntity(data, ContentType.APPLICATION_JSON));
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpTypeRequest);
            String response = null;
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                if (httpResponse.getEntity() != null) {
                    try (InputStream is = httpResponse.getEntity().getContent();){
                        response = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                JSONObject jsonResponse = new JSONObject(response);
                return jsonResponse.getJSONObject("data").getJSONArray("translations").getJSONObject(0).getString("translatedText");
            }
            String errorMessage = "Error when calling Google Translation API";
            try (InputStream is = httpResponse.getEntity().getContent();){
                JSONObject jsonResponse = new JSONObject(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                if (jsonResponse.getJSONObject(ERROR) != null && jsonResponse.getJSONObject(ERROR).getString("message") != null) {
                    errorMessage = jsonResponse.getJSONObject(ERROR).getString("message");
                }
            }
            LOG.error("remote_service={} operation={} parameters=\"message length:{},targetLocale:{}\" status=ko duration_ms={} error_msg=\"{}, status : {} \"", new Object[]{GOOGLE_TRANSLATE_SERVICE, "translate", message.length(), targetLocale.getLanguage(), System.currentTimeMillis() - startTime, errorMessage, statusCode});
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Error when trying to send translation request to google API", (Throwable)e);
            return null;
        }
    }
}

