/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputSet;

@Serialized
public class UIFormInputWithActions
extends UIFormInputSet {
    private static final Log log = ExoLogger.getLogger(UIFormInputWithActions.class);
    Map<String, List<ActionData>> actionField = new HashMap<String, List<ActionData>>();

    public UIFormInputWithActions() {
    }

    public UIFormInputWithActions(String id) {
        super.setId(id);
    }

    public void setActionField(String fieldName, List<ActionData> actions) {
        this.actionField.put(fieldName, actions);
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getComponentConfig() != null) {
            super.processRender(context);
            return;
        }
        JavascriptManager jsMan = context.getJavascriptManager();
        jsMan.require("SHARED/jquery", "$").require("SHARED/bts_tooltip").addScripts("$('." + this.getId() + " *[rel=\"tooltip\"]').tooltip();");
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        Writer w = context.getWriter();
        w.write("<div id=\"" + this.getId() + "\" class=\"UIFormInputSet " + this.getId() + "\">");
        w.write("<div class=\"form-horizontal\">");
        ResourceBundle res = context.getApplicationResourceBundle();
        boolean required = false;
        for (UIComponent inputEntry : this.getChildren()) {
            if (required || !(inputEntry instanceof UIFormInputBase)) continue;
            required = ((UIFormInputBase)inputEntry).isMandatory();
        }
        if (required) {
            w.write("<div class=\"require\">" + res.getString("legend.required_field") + " (*)</div>");
        }
        for (UIComponent inputEntry : this.getChildren()) {
            String label;
            if (!inputEntry.isRendered()) continue;
            try {
                label = uiForm.getLabel(res, inputEntry.getId());
                if (inputEntry instanceof UIFormInputBase) {
                    ((UIFormInputBase)inputEntry).setLabel(label);
                }
            }
            catch (MissingResourceException ex) {
                label = inputEntry.getId();
                log.error((Object)("\n " + uiForm.getId() + ".label." + inputEntry.getId() + " not found value"));
            }
            w.write("<div class=\"control-group\">");
            w.write("<label class=\"control-label\" for=\"" + inputEntry.getId() + "\">");
            w.write(label);
            w.write("</label>");
            w.write("<div class=\"controls\">");
            this.renderUIComponent(inputEntry);
            List<ActionData> actions = this.actionField.get(inputEntry.getName());
            if (actions != null) {
                for (ActionData action : actions) {
                    String actionLabel;
                    try {
                        actionLabel = uiForm.getLabel(res, "action." + action.getActionName());
                    }
                    catch (MissingResourceException ex) {
                        actionLabel = action.getActionName();
                        log.debug((Object)("Key: '" + uiForm.getId() + ".label.action." + action.getActionName() + "' not found"));
                    }
                    String actionLink = action.getActionParameter() != null ? this.getParent().event(action.getActionListener(), action.getActionParameter()) : this.getParent().event(action.getActionListener());
                    if (action.getActionType() == 0) {
                        w.write("<a rel=\"tooltip\" class=\"actionIcon\" data-placement=\"bottom\" title=\"" + actionLabel + "\" href=\"" + actionLink + "\"><i class=\"" + action.getCssIconClass() + "\"></i></a>");
                        if (action.isShowLabel) {
                            w.write(actionLabel);
                        }
                    } else if (action.getActionType() == 1) {
                        w.write("<a title=\"" + actionLabel + "\" href=\"" + actionLink + "\">" + actionLabel + "</a>");
                    }
                    w.write("&nbsp;");
                    if (!action.isBreakLine()) continue;
                    w.write("<br/>");
                }
            }
            w.write("</div>");
            w.write("</div>");
        }
        w.write("</div>");
        w.write("</div>");
    }

    public static class ActionData
    implements Serializable {
        public static final int TYPE_ICON = 0;
        public static final int TYPE_LINK = 1;
        private int actionType = 0;
        private String actionName;
        private String actionListener;
        private String actionParameter = null;
        private String cssIconClass = "AddNewNodeIcon";
        private boolean isShowLabel = false;
        private boolean isBreakLine = false;

        public void setActionType(int actionType) {
            this.actionType = actionType;
        }

        public int getActionType() {
            return this.actionType;
        }

        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public String getActionName() {
            return this.actionName;
        }

        public void setActionListener(String actionListener) {
            this.actionListener = actionListener;
        }

        public String getActionListener() {
            return this.actionListener;
        }

        public void setActionParameter(String actionParameter) {
            this.actionParameter = actionParameter;
        }

        public String getActionParameter() {
            return this.actionParameter;
        }

        public void setCssIconClass(String cssIconClass) {
            this.cssIconClass = cssIconClass;
        }

        public String getCssIconClass() {
            return this.cssIconClass;
        }

        public void setShowLabel(boolean isShowLabel) {
            this.isShowLabel = isShowLabel;
        }

        public boolean isShowLabel() {
            return this.isShowLabel;
        }

        public void setBreakLine(boolean isBreakLine) {
            this.isBreakLine = isBreakLine;
        }

        public boolean isBreakLine() {
            return this.isBreakLine;
        }
    }
}

