/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.saml;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.wci.ServletContainerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2LogOutHandler;

public class PortalSAML2LogOutHandler
extends SAML2LogOutHandler {
    private static final String COOKIE_NAME = "rememberme";
    private static final String OAUTH_COOKIE_NAME = "oauth_rememberme";
    private static Log log = ExoLogger.getLogger(PortalSAML2LogOutHandler.class);

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof LogoutRequestType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest servletRequest = httpContext.getRequest();
        HttpServletResponse servletResponse = httpContext.getResponse();
        super.handleRequestType(request, response);
        if (servletRequest.getSession(false) == null) {
            this.portalLogout(servletRequest, servletResponse);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof ResponseType) {
            return;
        }
        if (!(request.getSAML2Object() instanceof StatusResponseType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpServletRequest servletRequest = httpContext.getRequest();
        HttpServletResponse servletResponse = httpContext.getResponse();
        super.handleStatusResponseType(request, response);
        if (servletRequest.getSession(false) == null) {
            this.portalLogout(servletRequest, servletResponse);
        }
    }

    protected void portalLogout(HttpServletRequest request, HttpServletResponse response) {
        request.getSession(true);
        try {
            ServletContainerFactory.getServletContainer().logout(request, response);
        }
        catch (Exception e) {
            log.warn((Object)"Session has been invalidated but WCI logout failed.", (Throwable)e);
        }
        Cookie cookie = new Cookie(COOKIE_NAME, "");
        cookie.setPath(request.getContextPath());
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        Cookie oauthCookie = new Cookie(OAUTH_COOKIE_NAME, "");
        oauthCookie.setPath(request.getContextPath());
        oauthCookie.setMaxAge(0);
        response.addCookie(oauthCookie);
    }
}

