/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.service.WalletTransactionService;
import org.exoplatform.wallet.utils.WalletUtils;

public class CancelTransactionListener
extends Listener<Object, String> {
    private static final Log LOG = ExoLogger.getLogger(CancelTransactionListener.class);
    private WalletTransactionService walletTransactionService;
    private ListenerService listenerService;

    public void onEvent(Event<Object, String> event) throws Exception {
        Wallet wallet = (Wallet)event.getSource();
        String currentUserId = WalletUtils.getCurrentUserId();
        List pendingTransactions = this.getTransactionService().getTransactions(wallet.getAddress(), null, null, null, 0, true, false, currentUserId);
        if (pendingTransactions != null) {
            pendingTransactions.forEach(transactionDetail -> {
                transactionDetail.setPending(false);
                transactionDetail.setSucceeded(false);
                this.getTransactionService().saveTransactionDetail(transactionDetail, true);
                try {
                    this.getListenerService().broadcast("exo.wallet.transaction.modified", null, transactionDetail);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private WalletTransactionService getTransactionService() {
        if (this.walletTransactionService == null) {
            this.walletTransactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.walletTransactionService;
    }
}

