/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.web;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.login.UIParamsExtension;
import org.gatein.security.oauth.spi.OAuthProviderType;
import org.gatein.security.oauth.spi.OAuthProviderTypeRegistry;
import org.json.JSONArray;

public class OauthLoginParamsExtension
implements UIParamsExtension {
    private static final List<String> EXTENSION_NAMES = Collections.singletonList("LoginExtension");
    private static final String OAUTH_ENABLED_PARAM = "oAuthEnabled";
    private static final String OAUTH_PROVIDER_TYPES_PARAM = "oAuthProviderTypes";
    private static final String OAUTH_PROVIDER_URL_PARAM_PREFIX = "oAuthInitURL-";
    private OAuthProviderTypeRegistry oAuthProviderTypeRegistry;

    public OauthLoginParamsExtension(OAuthProviderTypeRegistry oAuthProviderTypeRegistry) {
        this.oAuthProviderTypeRegistry = oAuthProviderTypeRegistry;
    }

    public List<String> getExtensionNames() {
        return EXTENSION_NAMES;
    }

    public Map<String, Object> extendParameters(ControllerContext controllerContext, String extensionName) {
        if (this.oAuthProviderTypeRegistry.isOAuthEnabled() && CollectionUtils.isNotEmpty((Collection)this.oAuthProviderTypeRegistry.getEnabledOAuthProviders())) {
            HashMap<String, Object> oAuthProvidersParams = new HashMap<String, Object>();
            oAuthProvidersParams.put(OAUTH_ENABLED_PARAM, true);
            Set oAuthProviderTypes = this.oAuthProviderTypeRegistry.getEnabledOAuthProviders().stream().map(OAuthProviderType::getKey).collect(Collectors.toSet());
            oAuthProvidersParams.put(OAUTH_PROVIDER_TYPES_PARAM, new JSONArray(oAuthProviderTypes));
            String contextPath = controllerContext.getRequest().getContextPath();
            String initialUri = controllerContext.getRequest().getParameter("initialURI");
            if (StringUtils.isBlank((CharSequence)initialUri)) {
                initialUri = contextPath;
            }
            for (OAuthProviderType oAuthProvType : this.oAuthProviderTypeRegistry.getEnabledOAuthProviders()) {
                String oAuthProvTypeKey = oAuthProvType.getKey();
                String oAuthInitURL = oAuthProvType.getInitOAuthURL(contextPath, initialUri);
                oAuthProvidersParams.put(OAUTH_PROVIDER_URL_PARAM_PREFIX + oAuthProvTypeKey, oAuthInitURL);
            }
            return oAuthProvidersParams;
        }
        return null;
    }
}

