/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.tools;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.DummyContainerResponseWriter;
import org.exoplatform.services.rest.tools.SecurityContextRequest;

public class ResourceLauncher {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.ResourceLauncher");
    private final RequestHandler requestHandler;

    public ResourceLauncher(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, ContainerResponseWriter writer, EnvironmentContext env) throws Exception {
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        ByteArrayInputStream in = null;
        if (data != null) {
            in = new ByteArrayInputStream(data);
        }
        if (env == null) {
            env = new EnvironmentContext();
        }
        EnvironmentContext.setCurrent(env);
        if (writer == null) {
            writer = new DummyContainerResponseWriter();
        }
        SecurityContext sctx = (SecurityContext)env.get(SecurityContext.class);
        SecurityContextRequest request = new SecurityContextRequest(method, new URI(requestURI), new URI(baseURI), in, new InputHeadersMap(headers), sctx);
        ContainerResponse response = new ContainerResponse(writer);
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.requestHandler.handleRequest(request, response);
        }
        finally {
            Map results = RequestLifeCycle.end();
            for (Map.Entry entry : results.entrySet()) {
                if (entry.getValue() == null) continue;
                LOG.error((Object)("An error occurred while calling the method endRequest on " + entry.getKey()), (Throwable)entry.getValue());
            }
        }
        return response;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, EnvironmentContext env) throws Exception {
        return this.service(method, requestURI, baseURI, headers, data, new DummyContainerResponseWriter(), env);
    }
}

