/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import juzu.Response;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.bridge.spi.web.AsyncStream;
import juzu.impl.bridge.spi.web.HttpStream;
import juzu.impl.bridge.spi.web.WebStream;
import juzu.impl.common.RunMode;
import juzu.impl.compiler.CompilationException;
import juzu.impl.io.SafeStream;
import juzu.impl.plugin.asset.AssetService;
import juzu.request.Phase;
import juzu.request.RequestParameter;

public abstract class WebRequestContext {
    public final void send(CompilationException e) throws IOException {
        this.send(e.asResponse(), true);
    }

    public final void send(Response.Error error, boolean verbose) throws IOException {
        this.send(null, error.asStatus(verbose), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(AssetService assetPlugin, Response.Status response, Phase phase) throws IOException {
        AsyncStream stream = this.getStream(response.getCode());
        if (response instanceof Response.Content) {
            AssetManager assetManager = assetPlugin != null ? assetPlugin.getAssetManager() : null;
            stream = new WebStream((HttpStream)stream, assetManager, this.getRunMode().getMinifyAssets(), phase){

                @Override
                public String renderAssetURL(AssetLocation location, String uri) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        WebRequestContext.this.renderAssetURL(location, uri, sb);
                        return sb.toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new UnsupportedOperationException("handle me ", e);
                    }
                }
            };
        }
        try {
            response.streamable().send(new SafeStream(stream));
        }
        finally {
            stream.end();
        }
    }

    public abstract RunMode getRunMode();

    public abstract Map<String, RequestParameter> getParameters();

    public abstract String getRequestURI();

    public abstract String getPath();

    public abstract String getRequestPath();

    public abstract void setContentType(String var1, Charset var2);

    public abstract void setStatus(int var1);

    public abstract void setHeaders(Iterable<Map.Entry<String, String[]>> var1);

    public abstract void sendRedirect(String var1) throws IOException;

    public abstract HttpStream getStream(int var1);

    public abstract void renderAssetURL(AssetLocation var1, String var2, Appendable var3) throws IOException;
}

