/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.security.oauth.openid;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.io.Decoders;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteJwkSigningKeyResolver
implements SigningKeyResolver {
    private final String issuer;
    private final Object lock = new Object();
    private Map<String, Key> keyMap = new HashMap<String, Key>();
    private static final Log LOG = ExoLogger.getLogger(RemoteJwkSigningKeyResolver.class);

    RemoteJwkSigningKeyResolver(String issuer) {
        this.issuer = issuer;
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header.getKeyId());
    }

    public Key resolveSigningKey(JwsHeader header, String plaintext) {
        return this.getKey(header.getKeyId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getKey(String keyId) {
        Key result = this.keyMap.get(keyId);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.keyMap.get(keyId);
            if (result != null) {
                return result;
            }
            this.updateKeys();
            return this.keyMap.get(keyId);
        }
    }

    private void updateKeys() {
        JSONObject configuration = this.getJson(this.issuer + "/.well-known/openid-configuration");
        try {
            String jwksUrl = configuration != null ? configuration.getString("jwks_uri") : null;
            JSONObject keys = this.getJson(jwksUrl);
            JSONArray arraylist = keys != null ? keys.getJSONArray("keys") : null;
            HashMap<String, PublicKey> newKeys = new HashMap<String, PublicKey>();
            if (arraylist != null) {
                for (int i = 0; i < arraylist.length(); ++i) {
                    JSONObject jsonobjects = arraylist.getJSONObject(i);
                    if (!"sig".equals(jsonobjects.get("use")) || !"RSA".equals(jsonobjects.get("kty"))) continue;
                    BigInteger modulus = this.base64ToBigInteger(jsonobjects.getString("n"));
                    BigInteger exponent = this.base64ToBigInteger(jsonobjects.getString("e"));
                    RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, exponent);
                    PublicKey publicKey = null;
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
                    newKeys.put(jsonobjects.getString("kid"), publicKey);
                }
                this.keyMap = Collections.unmodifiableMap(newKeys);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)"can't get keys in JSONObject");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Failed to parse public key");
        }
    }

    public static Map<String, Object> toMap(JSONObject jsonobj) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonobj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List<Object> value = jsonobj.get(key);
            if (value instanceof JSONArray) {
                value = RemoteJwkSigningKeyResolver.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = RemoteJwkSigningKeyResolver.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = RemoteJwkSigningKeyResolver.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = RemoteJwkSigningKeyResolver.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    private JSONObject getJson(String url) {
        JSONObject jSONObject;
        block8: {
            InputStream input = new URL(url).openStream();
            try {
                BufferedReader re = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                String text = this.read(re);
                jSONObject = new JSONObject(text);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error when Read Data From BufferReader" + e.getMessage()));
                    return null;
                }
            }
            input.close();
        }
        return jSONObject;
    }

    public String read(Reader re) throws IOException {
        int temp;
        StringBuilder str = new StringBuilder();
        do {
            temp = re.read();
            str.append((char)temp);
        } while (temp != -1);
        return str.toString();
    }

    private BigInteger base64ToBigInteger(String value) {
        return new BigInteger(1, (byte[])Decoders.BASE64URL.decode((Object)value));
    }
}

