/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.news.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.news.filter.NewsFilter;
import org.exoplatform.news.model.News;
import org.exoplatform.news.model.NewsAttachment;
import org.exoplatform.news.rest.NewsEntity;
import org.exoplatform.news.search.NewsESSearchResult;
import org.exoplatform.news.service.NewsService;
import org.exoplatform.news.storage.NewsAttachmentsStorage;
import org.exoplatform.news.utils.EntityBuilder;
import org.exoplatform.news.utils.NewsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.picocontainer.Startable;

@Path(value="v1/news")
@Api(tags={"v1/news"}, value="v1/news", description="Managing news")
public class NewsRestResourcesV1
implements ResourceContainer,
Startable {
    private static final Log LOG = ExoLogger.getLogger(NewsRestResourcesV1.class);
    private static final String PUBLISHER_MEMBERSHIP_NAME = "publisher";
    private static final String PLATFORM_WEB_CONTRIBUTORS_GROUP = "/platform/web-contributors";
    private NewsService newsService;
    private NewsAttachmentsStorage newsAttachmentsService;
    private SpaceService spaceService;
    private IdentityManager identityManager;
    private ScheduledExecutorService scheduledExecutor;
    private PortalContainer container;
    private FavoriteService favoriteService;
    private Map<String, String> newsToDeleteQueue = new HashMap<String, String>();
    private static final int CACHE_DURATION_SECONDS = 31536000;
    private static final long CACHE_DURATION_MILLISECONDS = 31536000000L;
    private static final CacheControl ILLUSTRATION_CACHE_CONTROL = new CacheControl();

    public NewsRestResourcesV1(NewsService newsService, NewsAttachmentsStorage newsAttachmentsService, SpaceService spaceService, IdentityManager identityManager, PortalContainer container, FavoriteService favoriteService) {
        this.newsService = newsService;
        this.newsAttachmentsService = newsAttachmentsService;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
        this.container = container;
        this.favoriteService = favoriteService;
    }

    public void start() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a news", httpMethod="POST", response=Response.class, notes="This creates the news if the authenticated user is a member of the space or a spaces super manager. The news is created in draft status, unless the publicationState property is set to 'published'.")
    @ApiResponses(value={@ApiResponse(code=200, message="News created"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to create the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response createNews(@Context HttpServletRequest request, @ApiParam(value="News", required=true) News news) {
        if (news == null || StringUtils.isEmpty((CharSequence)news.getSpaceId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News createdNews = this.newsService.createNews(news, currentIdentity);
            return Response.ok((Object)createdNews).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to create news", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when creating the news " + news.getTitle()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="canCreateNews/{spaceId}")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="check if the current user can create a news in the given space", httpMethod="GET", response=Response.class, notes="This checks if the current user can create a news in the given space", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="User ability to create a news is returned"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to create a news"), @ApiResponse(code=404, message="Space not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response canCreateNews(@Context HttpServletRequest request, @ApiParam(value="space id", required=true) @PathParam(value="spaceId") String spaceId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)spaceId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)String.valueOf(this.newsService.canCreateNews(space, currentIdentity))).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to check if we can create news", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can create a news", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Create a news", httpMethod="PUT", response=Response.class, notes="This updates the news if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News updated"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to update the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateNews(@ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="Post news", required=false) @QueryParam(value="post") boolean post, @ApiParam(value="News", required=true) News updatedNews) {
        if (updatedNews == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News news = this.newsService.getNewsById(id, currentIdentity, false);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            news.setTitle(updatedNews.getTitle());
            news.setSummary(updatedNews.getSummary());
            news.setBody(updatedNews.getBody());
            news.setUploadId(updatedNews.getUploadId());
            news.setAttachments(updatedNews.getAttachments());
            news.setPublicationState(updatedNews.getPublicationState());
            news.setUpdaterFullName(updatedNews.getUpdaterFullName());
            news.setDraftVisible(updatedNews.isDraftVisible());
            news.setActivityPosted(updatedNews.isActivityPosted());
            news.setTargets(updatedNews.getTargets());
            news = this.newsService.updateNews(news, currentIdentity.getUserId(), post, updatedNews.isPublished());
            return Response.ok((Object)news).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to update news", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when updating the news " + id), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Delete news", httpMethod="DELETE", response=Response.class, notes="This deletes the news", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="News deleted"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to delete the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="Is draft to delete", defaultValue="false") @QueryParam(value="isDraft") boolean isDraft, @ApiParam(value="Time to effectively delete news", required=false) @QueryParam(value="delay") long delay) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            News news = this.newsService.getNewsById(id, currentIdentity, false);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (delay > 0L) {
                this.newsToDeleteQueue.put(id, currentIdentity.getUserId());
                this.scheduledExecutor.schedule(() -> {
                    if (this.newsToDeleteQueue.containsKey(id)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            this.newsToDeleteQueue.remove(id);
                            this.newsService.deleteNews(id, currentIdentity, isDraft);
                        }
                        catch (IllegalAccessException e) {
                            LOG.error("User '{}' attempts to delete a non authorized news", new Object[]{currentIdentity.getUserId(), e});
                        }
                        catch (Exception e) {
                            LOG.warn((Object)("Error when deleting the news with id " + id), (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.newsToDeleteQueue.remove(id);
                this.newsService.deleteNews(id, currentIdentity, isDraft);
            }
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to delete news", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when deleting the news with id " + id), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{id}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Undo deleting news if not yet effectively deleted.", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Forbidden operation"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response undoDeleteNews(@Context HttpServletRequest request, @ApiParam(value="News node identifier", required=true) @PathParam(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"News identifier must not be null or empty").build();
        }
        if (this.newsToDeleteQueue.containsKey(id)) {
            String authenticatedUser = request.getRemoteUser();
            String originalModifierUser = this.newsToDeleteQueue.get(id);
            if (!originalModifierUser.equals(authenticatedUser)) {
                LOG.warn("User {} attempts to cancel deletion of a news deleted by user {}", new Object[]{authenticatedUser, originalModifierUser});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.newsToDeleteQueue.remove(id);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("News with id {} was already deleted or isn't planned to be deleted" + id)).build();
    }

    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a news", httpMethod="GET", response=Response.class, notes="This gets the news with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsById(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="fields", required=true) @QueryParam(value="fields") String fields, @ApiParam(value="Is edit mode", defaultValue="false") @QueryParam(value="editMode") boolean editMode) {
        String authenticatedUser = request.getRemoteUser();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            News news = this.newsService.getNewsById(id, currentIdentity, editMode);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            news.setIllustration(null);
            if (StringUtils.isNotEmpty((CharSequence)fields) && fields.equals("spaces")) {
                News filteredNews = new News();
                ArrayList<String> spacesList = new ArrayList<String>();
                String newsActivities = news.getActivities();
                for (String newsActivity : newsActivities.split(";")) {
                    String spaceId = newsActivity.split(":")[0];
                    spacesList.add(spaceId);
                }
                filteredNews.setSharedInSpacesList(spacesList);
                return Response.ok((Object)filteredNews).build();
            }
            return Response.ok((Object)news).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempt to access unauthorized news with id {}", new Object[]{authenticatedUser, id});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="markAsRead/{id}")
    @RolesAllowed(value={"users"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="mark a news article as read", httpMethod="POST", response=Response.class, notes="This marks a news article as read by the user who accessed its details.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response markNewsAsRead(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id) {
        String authenticatedUser = request.getRemoteUser();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            News news = this.newsService.getNewsById(id, currentIdentity, false);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            this.newsService.markAsRead(news, authenticatedUser);
            return Response.ok((Object)"ok").type("text/plain").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} has no access rights on news with id {}", new Object[]{authenticatedUser, id});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Error while marking news with id: {} as read", new Object[]{id, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get news list", httpMethod="GET", response=Response.class, notes="This gets the list of news with the given search text, of the given author, in the given space or spaces, with the given publication state, with the given pinned state if the authenticated user is a member of the spaces or a super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News list returned"), @ApiResponse(code=401, message="User not authorized to get the news list"), @ApiResponse(code=404, message="News list not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNews(@Context HttpServletRequest request, @ApiParam(value="News author", required=true) @QueryParam(value="author") String author, @ApiParam(value="News spaces", required=true) @QueryParam(value="spaces") String spaces, @ApiParam(value="News filter", required=true) @QueryParam(value="filter") String filter, @ApiParam(value="search text", required=true) @QueryParam(value="text") String text, @ApiParam(value="News pagination offset", defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="News pagination limit", defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="News total size", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        try {
            List<News> news;
            String authenticatedUser = request.getRemoteUser();
            if (StringUtils.isBlank((CharSequence)author) || !authenticatedUser.equals(author)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            NewsEntity newsEntity = new NewsEntity();
            ArrayList<String> spacesList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)spaces)) {
                for (String spaceId : spaces.split(",")) {
                    Space space = this.spaceService.getSpaceById(spaceId);
                    if (space == null || !this.spaceService.isSuperManager(authenticatedUser) && !this.spaceService.isMember(space, authenticatedUser)) {
                        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                    spacesList.add(spaceId);
                }
            }
            NewsFilter newsFilter = this.buildFilter(spacesList, filter, text, author, limit, offset);
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                String lang = request.getLocale().getLanguage();
                news = this.newsService.searchNews(newsFilter, lang);
            } else {
                Identity currentIdentity = ConversationState.getCurrent().getIdentity();
                news = this.newsService.getNews(newsFilter, currentIdentity);
            }
            if (news != null && news.size() != 0) {
                for (News newsItem : news) {
                    newsItem.setIllustration(null);
                }
            }
            newsEntity.setNews(news);
            newsEntity.setOffset(offset);
            newsEntity.setLimit(limit);
            if (returnSize) {
                newsEntity.setSize(this.newsService.getNewsCount(newsFilter));
            }
            return Response.ok((Object)newsEntity).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news with params author=" + author + ", spaces=" + spaces), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="byTarget/{targetName}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get news list", httpMethod="GET", response=Response.class, notes="This gets the list of news by the given target.")
    @ApiResponses(value={@ApiResponse(code=200, message="News list returned"), @ApiResponse(code=401, message="User not authorized to get the news list"), @ApiResponse(code=404, message="News list not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsByTarget(@Context HttpServletRequest request, @ApiParam(value="News target name", required=true) @PathParam(value="targetName") String targetName, @ApiParam(value="News pagination offset", defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="News pagination limit", defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="News total size", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) {
        try {
            String authenticatedUser = request.getRemoteUser();
            if (StringUtils.isBlank((CharSequence)authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (StringUtils.isBlank((CharSequence)targetName)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (offset < 0) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
            }
            if (limit < 0) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
            }
            NewsFilter newsFilter = this.buildFilter(null, "", "", authenticatedUser, limit, offset);
            NewsEntity newsEntity = new NewsEntity();
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            List<News> news = this.newsService.getNewsByTargetName(newsFilter, targetName, currentIdentity);
            newsEntity.setNews(news);
            newsEntity.setOffset(offset);
            newsEntity.setLimit(limit);
            if (returnSize) {
                newsEntity.setSize(news.size());
            }
            return Response.ok((Object)newsEntity).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news with target name=" + targetName), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="byActivity/{activityId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a news identified by its activity or shared activity identifier", httpMethod="GET", response=Response.class, notes="This gets the news with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsByActivityId(@ApiParam(value="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News news = this.newsService.getNewsByActivityId(activityId, currentIdentity);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            news.setIllustration(null);
            return Response.ok((Object)news).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} attempt to access unauthorized news with id {}", new Object[]{currentIdentity.getUserId(), activityId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + activityId), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PATCH
    @Path(value="schedule")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Schedule a news", httpMethod="POST", response=Response.class, notes="This schedules the news if the authenticated user is a member of the space or a spaces super manager. The news is created in staged status, after reaching a date of publication startPublishedDate, the publicationState property is set to 'published'.")
    @ApiResponses(value={@ApiResponse(code=200, message="News scheduled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to schedule the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response scheduleNews(@Context HttpServletRequest request, @ApiParam(value="News", required=true) News scheduledNews) {
        if (scheduledNews == null || StringUtils.isEmpty((CharSequence)scheduledNews.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            News news = this.newsService.getNewsById(scheduledNews.getId(), currentIdentity, false);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            news = this.newsService.scheduleNews(scheduledNews, currentIdentity);
            return Response.ok((Object)news).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to schedule news", new Object[]{currentIdentity.getUserId(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when scheduling the news " + scheduledNews.getTitle()), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="search")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Search the list of news available with query", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response search(@Context UriInfo uriInfo, @Context HttpServletRequest request, @ApiParam(value="Term to search", required=true) @QueryParam(value="query") String query, @ApiParam(value="Properties to expand", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Tag names used to search news", required=true) @QueryParam(value="tags") List<String> tagNames, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Favorites", required=false, defaultValue="false") @QueryParam(value="favorites") boolean favorites) {
        if (StringUtils.isBlank((CharSequence)query) && !favorites && CollectionUtils.isEmpty(tagNames)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'query' parameter is mandatory").build();
        }
        String authenticatedUser = request.getRemoteUser();
        org.exoplatform.social.core.identity.model.Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        NewsFilter filter = new NewsFilter();
        filter.setSearchText(query);
        filter.setFavorites(favorites);
        filter.setLimit(limit);
        filter.setOffset(offset);
        filter.setTagNames(tagNames);
        List<NewsESSearchResult> searchResults = this.newsService.search(currentIdentity, filter);
        List results = searchResults.stream().map(searchResult -> EntityBuilder.fromNewsSearchResult(this.favoriteService, searchResult, currentIdentity, uriInfo)).collect(Collectors.toList());
        return Response.ok(results).build();
    }

    @GET
    @Path(value="attachments/{attachmentId}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a news attachment", httpMethod="GET", response=Response.class, notes="This gets the news attachment with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsAttachmentById(@Context HttpServletRequest request, @ApiParam(value="News attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        try {
            NewsAttachment attachment = this.newsAttachmentsService.getNewsAttachment(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)attachment).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news attachment " + attachmentId), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="attachments/{attachmentId}/file")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Download a news attachment", httpMethod="GET", response=Response.class, notes="This downloads the news attachment with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsAttachmentBinaryById(@Context HttpServletRequest request, @ApiParam(value="News attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        try {
            NewsAttachment attachment = this.newsAttachmentsService.getNewsAttachment(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            InputStream stream = this.newsAttachmentsService.getNewsAttachmentStream(attachmentId);
            Response.ResponseBuilder responseBuilder = Response.ok((Object)stream, (String)attachment.getMimetype());
            responseBuilder.header("Content-Disposition", (Object)("attachment; filename=\"" + attachment.getName() + "\""));
            return responseBuilder.build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news attachment " + attachmentId), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="attachments/{attachmentId}/open")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Opens a news attachment", httpMethod="GET", response=Response.class, notes="This opens the news attachment with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response openNewsAttachmentById(@Context HttpServletRequest request, @ApiParam(value="News attachment id", required=true) @PathParam(value="attachmentId") String attachmentId) {
        try {
            NewsAttachment attachment = this.newsAttachmentsService.getNewsAttachment(attachmentId);
            if (attachment == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String openUrl = this.newsAttachmentsService.getNewsAttachmentOpenUrl(attachmentId);
            return Response.temporaryRedirect((URI)URI.create(openUrl)).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news attachment " + attachmentId), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="{id}/illustration")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get a news illustration", httpMethod="GET", response=Response.class, notes="This gets the news illustration with the given id if the authenticated user is a member of the space or a spaces super manager.")
    @ApiResponses(value={@ApiResponse(code=200, message="News returned"), @ApiResponse(code=401, message="User not authorized to get the news"), @ApiResponse(code=404, message="News not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getNewsIllustration(@Context Request rsRequest, @Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="last modified date") @QueryParam(value="v") long lastModified) {
        try {
            Space space;
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            News news = this.newsService.getNewsById(id, currentIdentity, false);
            if (news == null || news.getIllustration() == null || news.getIllustration().length == 0) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (!news.isPublished() && (space = this.spaceService.getSpaceById(news.getSpaceId())) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            long lastUpdated = news.getIllustrationUpdateDate().getTime();
            EntityTag eTag = new EntityTag(String.valueOf(lastUpdated));
            Response.ResponseBuilder builder = rsRequest.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = Response.ok((Object)news.getIllustration(), (String)"image/webp");
                builder.tag(eTag);
                if (lastModified > 0L) {
                    builder.lastModified(new Date(lastUpdated));
                    builder.expires(new Date(System.currentTimeMillis() + 31536000000L));
                    builder.cacheControl(ILLUSTRATION_CACHE_CONTROL);
                }
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when getting the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="{id}/click")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Log a click action on a news", httpMethod="POST", response=Response.class, notes="This logs a message when the user performs a click on a news")
    @ApiResponses(value={@ApiResponse(code=200, message="Click logged"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response clickOnNews(@Context UriInfo uriInfo, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="The clicked element", required=true) String clickedElement) {
        News news;
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser, false);
        try {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            news = this.newsService.getNewsById(id, currentIdentity, false);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while getting news with id " + id), (Throwable)e);
            return Response.serverError().build();
        }
        Space space = this.spaceService.getSpaceById(news.getSpaceId());
        LOG.info("service=news operation=click_on_{} parameters=\"news_id:{},space_name:{},space_id:{},user_id:{}\"", new Object[]{clickedElement, news.getId(), space != null ? space.getPrettyName() : "", space != null ? space.getId() : "", currentUser.getId()});
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Update a news", httpMethod="PATCH", response=Response.class, notes="This updates the sent fields of a news")
    @ApiResponses(value={@ApiResponse(code=200, message="News updated"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to update the news"), @ApiResponse(code=500, message="Internal server error")})
    public Response patchNews(@Context HttpServletRequest request, @ApiParam(value="News id", required=true) @PathParam(value="id") String id, @ApiParam(value="News", required=true) News updatedNews) {
        if (updatedNews == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String authenticatedUser = request.getRemoteUser();
        try {
            boolean isUpdatedIllustration;
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            News news = this.newsService.getNewsById(id, currentIdentity, false);
            if (news == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Space space = this.spaceService.getSpaceById(news.getSpaceId());
            if (space == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            if (updatedNews.isArchived() != news.isArchived()) {
                boolean canArchiveOrUnarchiveNews;
                boolean bl = canArchiveOrUnarchiveNews = currentIdentity.isMemberOf(PLATFORM_WEB_CONTRIBUTORS_GROUP, PUBLISHER_MEMBERSHIP_NAME) || currentIdentity.getUserId().equals(news.getAuthor());
                if (!canArchiveOrUnarchiveNews) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                news.setArchived(updatedNews.isArchived());
                if (news.isArchived()) {
                    this.newsService.archiveNews(id, currentIdentity.getUserId());
                } else {
                    this.newsService.unarchiveNews(id, currentIdentity.getUserId());
                }
            }
            boolean isUpdatedTitle = updatedNews.getTitle() != null && !updatedNews.getTitle().equals(news.getTitle());
            boolean isUpdatedSummary = updatedNews.getSummary() != null && !updatedNews.getSummary().equals(news.getSummary());
            boolean isUpdatedBody = updatedNews.getBody() != null && !updatedNews.getBody().equals(news.getBody());
            boolean bl = isUpdatedIllustration = updatedNews.getUploadId() != null && !updatedNews.getUploadId().equals(news.getUploadId());
            if (isUpdatedTitle || isUpdatedSummary || isUpdatedBody || isUpdatedIllustration) {
                if (!news.isCanEdit()) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                if (isUpdatedTitle) {
                    news.setTitle(updatedNews.getTitle());
                }
                if (isUpdatedSummary) {
                    news.setSummary(updatedNews.getSummary());
                }
                if (isUpdatedBody) {
                    news.setBody(updatedNews.getBody());
                }
                if (isUpdatedIllustration) {
                    news.setUploadId(updatedNews.getUploadId());
                }
                news = this.newsService.updateNews(news, authenticatedUser, null, updatedNews.isPublished());
            }
            return Response.ok((Object)news).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not autorized to patch news", new Object[]{authenticatedUser, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error when trying to update the news " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="canScheduleNews/{spaceId}")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="check if the current user can schedule a news in the given space", httpMethod="GET", response=Response.class, notes="This checks if the current user can schedule a news in the given space", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="User ability to schedule a news"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="User not authorized to schedule a news"), @ApiResponse(code=404, message="Space not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response canScheduleNews(@ApiParam(value="space id", required=true) @PathParam(value="spaceId") String spaceId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)spaceId)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)String.valueOf(this.newsService.canScheduleNews(space, currentIdentity))).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can schedule a news", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="canPublishNews")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="check if the current user can publish a news to all users", httpMethod="GET", response=Response.class, notes="This checks if the current user can publish a news to all users", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="User ability to publish a news is returned"), @ApiResponse(code=401, message="User not authorized to publish a news")})
    public Response canPublishNews(@Context HttpServletRequest request) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            return Response.ok((Object)String.valueOf(NewsUtils.canPublishNews(currentIdentity))).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when checking if the authenticated user can publish a news to all users", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private NewsFilter buildFilter(List<String> spaces, String filter, String text, String author, int limit, int offset) {
        NewsFilter newsFilter = new NewsFilter();
        newsFilter.setSpaces(spaces);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            FilterType filterType = FilterType.valueOf(filter.toUpperCase());
            switch (filterType) {
                case PINNED: {
                    newsFilter.setPublishedNews(true);
                    break;
                }
                case MYPOSTED: {
                    if (!StringUtils.isNotEmpty((CharSequence)author)) break;
                    newsFilter.setAuthor(author);
                    break;
                }
                case ARCHIVED: {
                    newsFilter.setArchivedNews(true);
                    break;
                }
                case DRAFTS: {
                    if (StringUtils.isNotEmpty((CharSequence)author)) {
                        newsFilter.setAuthor(author);
                    }
                    newsFilter.setDraftNews(true);
                    break;
                }
                case SCHEDULED: {
                    if (StringUtils.isNotEmpty((CharSequence)author)) {
                        newsFilter.setAuthor(author);
                    }
                    newsFilter.setScheduledNews(true);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            newsFilter.setSearchText(text);
        }
        newsFilter.setOrder("exo:dateModified");
        newsFilter.setLimit(limit);
        newsFilter.setOffset(offset);
        return newsFilter;
    }

    static {
        ILLUSTRATION_CACHE_CONTROL.setMaxAge(31536000);
    }

    private static enum FilterType {
        PINNED,
        MYPOSTED,
        ARCHIVED,
        DRAFTS,
        SCHEDULED,
        ALL;

    }
}

