/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.tag;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagFilter;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="v1/social/tags")
@Api(tags={"v1/social/tags"}, value="v1/social/tags", description="Managing tags for any type of data")
public class TagRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(TagRest.class);
    private TagService tagService;

    public TagRest(TagService tagService) {
        this.tagService = tagService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Find list of tags using a search term", httpMethod="POST", response=Response.class, produces="application/json", notes="Returns list of tags")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response findTags(@ApiParam(value="Search term", required=false, defaultValue="false") @QueryParam(value="q") String term, @ApiParam(value="Search results limit", required=false, defaultValue="false") @QueryParam(value="limit") long limit) {
        long userIdentityId = RestUtils.getCurrentUserIdentityId();
        try {
            List tagNames = this.tagService.findTags(new TagFilter(term, limit), userIdentityId);
            return Response.ok((Object)tagNames).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting list of tags", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

