/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.CQJDBCStorageConnection;

public class MultiDbJDBCConnection
extends CQJDBCStorageConnection {
    protected String FIND_NODES_BY_PARENTID_CQ_QUERY;
    protected String FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
    protected String FIND_ITEM_QPATH_BY_ID_CQ_QUERY;

    public MultiDbJDBCConnection(Connection dbConnection, boolean readOnly, JDBCDataContainerConfig containerConfig) throws SQLException {
        super(dbConnection, readOnly, containerConfig);
    }

    @Override
    protected String getIdentifier(String internalId) {
        return internalId;
    }

    @Override
    protected String getInternalId(String identifier) {
        return identifier;
    }

    @Override
    protected void prepareQueries() throws SQLException {
        this.FIND_NODES_BY_PARENTID_CQ_QUERY = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_ITEM + " I, " + this.JCR_ITEM + " P, " + this.JCR_VALUE + " V where I.I_CLASS=1 and I.PARENT_ID=? and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        this.FIND_PROPERTIES_BY_PARENTID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from " + this.JCR_ITEM + " I LEFT OUTER JOIN " + this.JCR_VALUE + " V ON (V.PROPERTY_ID=I.ID) where I.I_CLASS=2 and I.PARENT_ID=? order by I.NAME";
        this.FIND_ITEM_QPATH_BY_ID_CQ_QUERY = "select I.ID, I.PARENT_ID, I.NAME, I.I_INDEX from " + this.JCR_ITEM + " I, (SELECT ID, PARENT_ID from " + this.JCR_ITEM + " where ID=?) J where I.ID = J.ID or I.ID = J.PARENT_ID";
        this.FIND_ITEM_BY_ID = "select * from " + this.JCR_ITEM + " where ID=?";
        this.FIND_ITEM_BY_NAME = "select * from " + this.JCR_ITEM + " I where PARENT_ID=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V where I.I_CLASS=2 and I.PARENT_ID=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_REFERENCES = "select P.ID, P.PARENT_ID, P.VERSION, P.P_TYPE, P.P_MULTIVALUED, P.NAME from " + this.JCR_REF + " R, " + this.JCR_ITEM + " P where R.NODE_ID=? and P.ID=R.PROPERTY_ID and P.I_CLASS=2";
        this.FIND_VALUES_BY_PROPERTYID = "select PROPERTY_ID, ORDER_NUM, DATA, STORAGE_DESC from " + this.JCR_VALUE + " where PROPERTY_ID=? order by ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from " + this.JCR_ITEM + " where I_CLASS=1 and PARENT_ID=? order by N_ORDER_NUM";
        this.FIND_NODES_BY_PARENTID_CQ = this.FIND_NODES_BY_PARENTID_CQ_QUERY;
        this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ = "select I.NAME, V.DATA, V.ORDER_NUM from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V where I.I_CLASS=2 and I.PARENT_ID=? and (I.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or I.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and I.ID=V.PROPERTY_ID";
        this.FIND_ITEM_QPATH_BY_ID_CQ = this.FIND_ITEM_QPATH_BY_ID_CQ_QUERY;
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from " + this.JCR_ITEM + " where I_CLASS=1 and PARENT_ID=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from " + this.JCR_ITEM + " where I_CLASS=1 and PARENT_ID=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from " + this.JCR_ITEM + " where I_CLASS=2 and PARENT_ID=? order by NAME";
        this.FIND_PROPERTIES_BY_PARENTID_CQ = this.FIND_PROPERTIES_BY_PARENTID_CQ_QUERY;
        this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_CLASS, I.I_INDEX, I.N_ORDER_NUM, I.P_TYPE, I.P_MULTIVALUED, V.ORDER_NUM, V.DATA, V.STORAGE_DESC from " + this.JCR_ITEM + " I LEFT OUTER JOIN " + this.JCR_VALUE + " V ON (V.PROPERTY_ID=I.ID)";
        this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE = "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_ITEM + " I, " + this.JCR_ITEM + " P, " + this.JCR_VALUE + " V";
        this.FIND_MAX_PROPERTY_VERSIONS = "select max(VERSION) FROM " + this.JCR_ITEM + " WHERE PARENT_ID=? and NAME=? and I_INDEX=? and I_CLASS=2";
        this.INSERT_NODE = "insert into " + this.JCR_ITEM + " (ID, PARENT_ID, NAME, VERSION, I_CLASS, I_INDEX, N_ORDER_NUM) VALUES(?,?,?,?,1,?,?)";
        this.INSERT_PROPERTY = "insert into " + this.JCR_ITEM + "(ID, PARENT_ID, NAME, VERSION, I_CLASS, I_INDEX, P_TYPE, P_MULTIVALUED) VALUES(?,?,?,?,2,?,?,?)";
        this.INSERT_VALUE = "insert into " + this.JCR_VALUE + "(DATA, ORDER_NUM, PROPERTY_ID, STORAGE_DESC) VALUES(?,?,?,?)";
        this.INSERT_REF = "insert into " + this.JCR_REF + "(NODE_ID, PROPERTY_ID, ORDER_NUM) VALUES(?,?,?)";
        this.RENAME_NODE = "update " + this.JCR_ITEM + " set PARENT_ID=?, NAME =?, VERSION=?, I_INDEX =?, N_ORDER_NUM =? where ID=?";
        this.UPDATE_NODE = "update " + this.JCR_ITEM + " set VERSION=?, I_INDEX=?, N_ORDER_NUM=? where ID=?";
        this.UPDATE_PROPERTY = "update " + this.JCR_ITEM + " set VERSION=?, P_TYPE=? where ID=?";
        this.DELETE_ITEM = "delete from " + this.JCR_ITEM + " where ID=?";
        this.DELETE_VALUE = "delete from " + this.JCR_VALUE + " where PROPERTY_ID=?";
        this.DELETE_REF = "delete from " + this.JCR_REF + " where PROPERTY_ID=?";
        this.FIND_NODES_AND_PROPERTIES = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P join (select I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from " + this.JCR_ITEM + " I where I.I_CLASS=1 AND I.ID > ? order by I.ID LIMIT ? OFFSET ?) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and V.PROPERTY_ID=P.ID  order by J.ID";
        this.FIND_PROPERTY_BY_ID = "select length(DATA), I.P_TYPE, V.STORAGE_DESC from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V where I.ID = ? and V.PROPERTY_ID = I.ID";
        this.DELETE_VALUE_BY_ORDER_NUM = "delete from " + this.JCR_VALUE + " where PROPERTY_ID=? and ORDER_NUM >= ?";
        this.DELETE_REFERENCE_BY_ORDER_NUM = "delete from " + this.JCR_REF + " where PROPERTY_ID=? and ORDER_NUM >= ?";
        this.UPDATE_VALUE = "update " + this.JCR_VALUE + " set DATA=?, STORAGE_DESC=? where PROPERTY_ID=? and ORDER_NUM=?";
        this.UPDATE_REFERENCE = "update " + this.JCR_REF + " set NODE_ID=? where PROPERTY_ID=? and ORDER_NUM=?";
        this.FIND_NODES_BY_PARENTID_LAZILY_CQ = this.containerConfig.useSequenceForOrderNumber ? "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_VALUE + " V, " + this.JCR_ITEM + " P  join (select J.* from " + this.JCR_ITEM + " J where J.I_CLASS=1 and J.PARENT_ID=? order by J.N_ORDER_NUM, J.ID  LIMIT ? OFFSET ?) I on P.PARENT_ID = I.ID where P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID" : "select I.*, P.NAME AS PROP_NAME, V.ORDER_NUM, V.DATA from " + this.JCR_ITEM + " I, " + this.JCR_ITEM + " P, " + this.JCR_VALUE + " V where I.I_CLASS=1 and I.PARENT_ID=? and I.N_ORDER_NUM >= ? and I.N_ORDER_NUM <= ? and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType' or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions') and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID";
        this.FIND_ACL_HOLDERS = "select I.PARENT_ID, I.P_TYPE  from " + this.JCR_ITEM + " I where I.I_CLASS=2 and (I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner' or I.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')";
        this.FIND_NODES_COUNT = "select count(*) from " + this.JCR_ITEM + " I where I.I_CLASS=1";
        this.FIND_WORKSPACE_DATA_SIZE = "select sum(length(DATA)) from " + this.JCR_VALUE;
        this.FIND_WORKSPACE_PROPERTIES_ON_VALUE_STORAGE = "select PROPERTY_ID, STORAGE_DESC, ORDER_NUM from " + this.JCR_VALUE + " where STORAGE_DESC is not null";
        this.FIND_NODE_DATA_SIZE = "select sum(length(DATA)) from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V  where I.PARENT_ID=? and I.I_CLASS=2 and I.ID=V.PROPERTY_ID";
        this.FIND_NODE_PROPERTIES_ON_VALUE_STORAGE = "select V.PROPERTY_ID, V.STORAGE_DESC, V.ORDER_NUM from " + this.JCR_ITEM + " I, " + this.JCR_VALUE + " V  where I.PARENT_ID=? and I.I_CLASS=2 and I.ID=V.PROPERTY_ID and V.STORAGE_DESC is not null";
        this.FIND_VALUE_STORAGE_DESC_AND_SIZE = "select length(DATA), STORAGE_DESC from " + this.JCR_VALUE + " where PROPERTY_ID=?";
    }

    @Override
    protected int addNodeRecord(NodeData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertNode == null) {
            this.insertNode = this.dbConnection.prepareStatement(this.INSERT_NODE);
        } else {
            this.insertNode.clearParameters();
        }
        this.insertNode.setString(1, data.getIdentifier());
        this.insertNode.setString(2, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : data.getParentIdentifier());
        this.insertNode.setString(3, data.getQPath().getName().getAsString());
        this.insertNode.setInt(4, data.getPersistedVersion());
        this.insertNode.setInt(5, data.getQPath().getIndex());
        this.insertNode.setInt(6, data.getOrderNumber());
        return this.executeUpdate(this.insertNode, 32);
    }

    @Override
    protected int addPropertyRecord(PropertyData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertProperty == null) {
            this.insertProperty = this.dbConnection.prepareStatement(this.INSERT_PROPERTY);
        } else {
            this.insertProperty.clearParameters();
        }
        this.insertProperty.setString(1, data.getIdentifier());
        this.insertProperty.setString(2, data.getParentIdentifier());
        this.insertProperty.setString(3, data.getQPath().getName().getAsString());
        this.insertProperty.setInt(4, data.getPersistedVersion());
        this.insertProperty.setInt(5, data.getQPath().getIndex());
        this.insertProperty.setInt(6, data.getType());
        this.insertProperty.setBoolean(7, data.isMultiValued());
        return this.executeUpdate(this.insertProperty, 64);
    }

    @Override
    protected int addReference(PropertyData data) throws SQLException, IOException, InvalidItemStateException, RepositoryException {
        if (data.getQPath().getAsString().indexOf("versionableUuid") > 0) {
            LOG.info((Object)("add ref versionableUuid " + data.getQPath().getAsString()));
        }
        List<ValueData> values = data.getValues();
        int added = 0;
        for (int i = 0; i < values.size(); ++i) {
            String refNodeIdentifier;
            ValueData vdata = values.get(i);
            try {
                refNodeIdentifier = ValueDataUtil.getString(vdata);
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage(), e);
            }
            added += this.addReference(data.getIdentifier(), i, refNodeIdentifier);
        }
        return added;
    }

    @Override
    protected int deleteReferenceByOrderNum(String id, int orderNum) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteReferenceByOrderNum == null) {
            this.deleteReferenceByOrderNum = this.dbConnection.prepareStatement(this.DELETE_REFERENCE_BY_ORDER_NUM);
        } else {
            this.deleteReferenceByOrderNum.clearParameters();
        }
        this.deleteReferenceByOrderNum.setString(1, id);
        this.deleteReferenceByOrderNum.setInt(2, orderNum);
        return this.executeUpdate(this.deleteReferenceByOrderNum, 131072);
    }

    @Override
    protected int addReference(String cid, int i, String refNodeIdentifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertReference == null) {
            this.insertReference = this.dbConnection.prepareStatement(this.INSERT_REF);
        } else {
            this.insertReference.clearParameters();
        }
        this.insertReference.setString(1, refNodeIdentifier);
        this.insertReference.setString(2, cid);
        this.insertReference.setInt(3, i);
        return this.executeUpdate(this.insertReference, 128);
    }

    @Override
    protected int updateReference(String cid, int i, String refNodeIdentifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateReference == null) {
            this.updateReference = this.dbConnection.prepareStatement(this.UPDATE_REFERENCE);
        } else {
            this.updateReference.clearParameters();
        }
        this.updateReference.setString(1, refNodeIdentifier);
        this.updateReference.setString(2, cid);
        this.updateReference.setInt(3, i);
        return this.executeUpdate(this.updateReference, 4096);
    }

    @Override
    protected int deleteReference(String propertyIdentifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteReference == null) {
            this.deleteReference = this.dbConnection.prepareStatement(this.DELETE_REF);
        } else {
            this.deleteReference.clearParameters();
        }
        this.deleteReference.setString(1, propertyIdentifier);
        return this.executeUpdate(this.deleteReference, 16384);
    }

    @Override
    protected int deleteItemByIdentifier(String identifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteItem == null) {
            this.deleteItem = this.dbConnection.prepareStatement(this.DELETE_ITEM);
        } else {
            this.deleteItem.clearParameters();
        }
        this.deleteItem.setString(1, identifier);
        return this.executeUpdate(this.deleteItem, 8192);
    }

    @Override
    protected int updateNodeByIdentifier(int version, int index, int orderNumb, String identifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateNode == null) {
            this.updateNode = this.dbConnection.prepareStatement(this.UPDATE_NODE);
        } else {
            this.updateNode.clearParameters();
        }
        this.updateNode.setInt(1, version);
        this.updateNode.setInt(2, index);
        this.updateNode.setInt(3, orderNumb);
        this.updateNode.setString(4, identifier);
        return this.executeUpdate(this.updateNode, 512);
    }

    @Override
    protected int updatePropertyByIdentifier(int version, int type, String identifier) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateProperty == null) {
            this.updateProperty = this.dbConnection.prepareStatement(this.UPDATE_PROPERTY);
        } else {
            this.updateProperty.clearParameters();
        }
        this.updateProperty.setInt(1, version);
        this.updateProperty.setInt(2, type);
        this.updateProperty.setString(3, identifier);
        return this.executeUpdate(this.updateProperty, 1024);
    }

    @Override
    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, parentId);
        this.findItemByName.setString(2, name);
        this.findItemByName.setInt(3, index);
        return this.findItemByName.executeQuery();
    }

    @Override
    protected ResultSet findPropertyByName(String parentId, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, parentId);
        this.findPropertyByName.setString(2, name);
        return this.findPropertyByName.executeQuery();
    }

    @Override
    protected ResultSet findItemByIdentifier(String identifier) throws SQLException {
        if (this.findItemById == null) {
            this.findItemById = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_ID);
        } else {
            this.findItemById.clearParameters();
        }
        this.findItemById.setString(1, identifier);
        return this.findItemById.executeQuery();
    }

    @Override
    protected ResultSet findReferences(String nodeIdentifier) throws SQLException {
        if (this.findReferences == null) {
            this.findReferences = this.dbConnection.prepareStatement(this.FIND_REFERENCES);
        } else {
            this.findReferences.clearParameters();
        }
        this.findReferences.setString(1, nodeIdentifier);
        return this.findReferences.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, parentIdentifier);
        return this.findNodesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodesByParentIdCQ == null) {
            this.findNodesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_CQ);
        } else {
            this.findNodesByParentIdCQ.clearParameters();
        }
        this.findNodesByParentIdCQ.setString(1, parentIdentifier);
        return this.findNodesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifierCQ(String parentIdentifier, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findNodesByParentIdAndComplexPatternCQ == null) {
            this.findNodesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_NODES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.I_CLASS=1 and I.PARENT_ID='");
        query.append(parentIdentifier);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), true);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), true);
        }
        query.append(" ) and P.I_CLASS=2 and P.PARENT_ID=I.ID and (P.NAME='[http://www.jcp.org/jcr/1.0]primaryType'");
        query.append(" or P.NAME='[http://www.jcp.org/jcr/1.0]mixinTypes'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]owner'");
        query.append(" or P.NAME='[http://www.exoplatform.com/jcr/exo/1.0]permissions')");
        query.append(" and V.PROPERTY_ID=P.ID order by I.N_ORDER_NUM, I.ID");
        return this.findNodesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        } else {
            this.findLastOrderNumberByParentId.clearParameters();
        }
        this.findLastOrderNumberByParentId.setString(1, parentIdentifier);
        return this.findLastOrderNumberByParentId.executeQuery();
    }

    @Override
    protected ResultSet findLastOrderNumber(int localMaxOrderNumber, boolean increment) throws SQLException {
        if (this.findLastOrderNumber == null) {
            this.findLastOrderNumber = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER);
        } else {
            this.findLastOrderNumber.clearParameters();
        }
        int value = increment ? 1 : 0;
        this.findLastOrderNumber.setInt(1, localMaxOrderNumber);
        this.findLastOrderNumber.setInt(2, value);
        return this.findLastOrderNumber.executeQuery();
    }

    @Override
    protected ResultSet findChildNodesCountByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, parentIdentifier);
        return this.findNodesCountByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, parentIdentifier);
        return this.findPropertiesByParentId.executeQuery();
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentCid, List<QPathEntryFilter> pattern) throws SQLException {
        if (pattern.isEmpty()) {
            throw new SQLException("Pattern list is empty.");
        }
        if (this.findPropertiesByParentIdAndComplexPatternCQ == null) {
            this.findPropertiesByParentIdAndComplexPatternCQ = this.dbConnection.createStatement();
        }
        StringBuilder query = new StringBuilder(this.FIND_PROPERTIES_BY_PARENTID_AND_PATTERN_CQ_TEMPLATE);
        query.append(" where I.I_CLASS=2 and I.PARENT_ID='");
        query.append(parentCid);
        query.append("' and ( ");
        this.appendPattern(query, pattern.get(0).getQPathEntry(), false);
        for (int i = 1; i < pattern.size(); ++i) {
            query.append(" or ");
            this.appendPattern(query, pattern.get(i).getQPathEntry(), false);
        }
        query.append(" ) order by I.NAME");
        return this.findPropertiesByParentIdAndComplexPatternCQ.executeQuery(query.toString());
    }

    @Override
    protected ResultSet findChildNodesByParentIdentifier(String parentCid, int fromOrderNum, int offset, int limit) throws SQLException {
        if (this.findNodesByParentIdLazilyCQ == null) {
            this.findNodesByParentIdLazilyCQ = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID_LAZILY_CQ);
        } else {
            this.findNodesByParentIdLazilyCQ.clearParameters();
        }
        this.findNodesByParentIdLazilyCQ.setString(1, parentCid);
        if (this.containerConfig.useSequenceForOrderNumber) {
            this.findNodesByParentIdLazilyCQ.setInt(2, limit);
            this.findNodesByParentIdLazilyCQ.setInt(3, offset);
        } else {
            this.findNodesByParentIdLazilyCQ.setInt(2, fromOrderNum);
            this.findNodesByParentIdLazilyCQ.setInt(3, fromOrderNum + limit - 1);
        }
        return this.findNodesByParentIdLazilyCQ.executeQuery();
    }

    @Override
    protected int addValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.insertValue == null) {
            this.insertValue = this.dbConnection.prepareStatement(this.INSERT_VALUE);
        } else {
            this.insertValue.clearParameters();
        }
        if (stream == null) {
            this.insertValue.setNull(1, -2);
            this.insertValue.setString(4, storageDesc);
        } else {
            this.insertValue.setBinaryStream(1, stream, streamLength);
            this.insertValue.setNull(4, 12);
        }
        this.insertValue.setInt(2, orderNumber);
        this.insertValue.setString(3, cid);
        return this.executeUpdate(this.insertValue, 256);
    }

    @Override
    protected int deleteValueData(String cid) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteValue == null) {
            this.deleteValue = this.dbConnection.prepareStatement(this.DELETE_VALUE);
        } else {
            this.deleteValue.clearParameters();
        }
        this.deleteValue.setString(1, cid);
        return this.executeUpdate(this.deleteValue, 32768);
    }

    @Override
    protected ResultSet findValuesByPropertyId(String cid) throws SQLException {
        if (this.findValuesByPropertyId == null) {
            this.findValuesByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_BY_PROPERTYID);
        } else {
            this.findValuesByPropertyId.clearParameters();
        }
        this.findValuesByPropertyId.setString(1, cid);
        return this.findValuesByPropertyId.executeQuery();
    }

    @Override
    protected int renameNode(NodeData data) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.renameNode == null) {
            this.renameNode = this.dbConnection.prepareStatement(this.RENAME_NODE);
        } else {
            this.renameNode.clearParameters();
        }
        this.renameNode.setString(1, data.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : data.getParentIdentifier());
        this.renameNode.setString(2, data.getQPath().getName().getAsString());
        this.renameNode.setInt(3, data.getPersistedVersion());
        this.renameNode.setInt(4, data.getQPath().getIndex());
        this.renameNode.setInt(5, data.getOrderNumber());
        this.renameNode.setString(6, data.getIdentifier());
        return this.executeUpdate(this.renameNode, 262144);
    }

    @Override
    protected ResultSet findChildPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findPropertiesByParentIdCQ == null) {
            this.findPropertiesByParentIdCQ = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findPropertiesByParentIdCQ.clearParameters();
        }
        this.findPropertiesByParentIdCQ.setString(1, parentIdentifier);
        return this.findPropertiesByParentIdCQ.executeQuery();
    }

    @Override
    protected ResultSet findNodeMainPropertiesByParentIdentifierCQ(String parentIdentifier) throws SQLException {
        if (this.findNodeMainPropertiesByParentIdentifierCQ == null) {
            this.findNodeMainPropertiesByParentIdentifierCQ = this.dbConnection.prepareStatement(this.FIND_NODE_MAIN_PROPERTIES_BY_PARENTID_CQ);
        } else {
            this.findNodeMainPropertiesByParentIdentifierCQ.clearParameters();
        }
        this.findNodeMainPropertiesByParentIdentifierCQ.setString(1, parentIdentifier);
        return this.findNodeMainPropertiesByParentIdentifierCQ.executeQuery();
    }

    @Override
    protected ResultSet findItemQPathByIdentifierCQ(String identifier) throws SQLException {
        if (this.findItemQPathByIdentifierCQ == null) {
            this.findItemQPathByIdentifierCQ = this.dbConnection.prepareStatement(this.FIND_ITEM_QPATH_BY_ID_CQ);
        } else {
            this.findItemQPathByIdentifierCQ.clearParameters();
        }
        this.findItemQPathByIdentifierCQ.setString(1, identifier);
        return this.findItemQPathByIdentifierCQ.executeQuery();
    }

    @Override
    protected int deleteValueDataByOrderNum(String id, int orderNum) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.deleteValueDataByOrderNum == null) {
            this.deleteValueDataByOrderNum = this.dbConnection.prepareStatement(this.DELETE_VALUE_BY_ORDER_NUM);
        } else {
            this.deleteValueDataByOrderNum.clearParameters();
        }
        this.deleteValueDataByOrderNum.setString(1, id);
        this.deleteValueDataByOrderNum.setInt(2, orderNum);
        return this.executeUpdate(this.deleteValueDataByOrderNum, 65536);
    }

    @Override
    protected ResultSet findPropertyById(String id) throws SQLException {
        if (this.findPropertyById == null) {
            this.findPropertyById = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_ID);
        } else {
            this.findPropertyById.clearParameters();
        }
        this.findPropertyById.setString(1, id);
        return this.findPropertyById.executeQuery();
    }

    @Override
    protected int updateValueData(String cid, int orderNumber, InputStream stream, int streamLength, String storageDesc) throws SQLException, InvalidItemStateException, RepositoryException {
        if (this.updateValue == null) {
            this.updateValue = this.dbConnection.prepareStatement(this.UPDATE_VALUE);
        } else {
            this.updateValue.clearParameters();
        }
        if (stream == null) {
            this.updateValue.setNull(1, -2);
            this.updateValue.setString(2, storageDesc);
        } else {
            this.updateValue.setBinaryStream(1, stream, streamLength);
            this.updateValue.setNull(2, 12);
        }
        this.updateValue.setString(3, cid);
        this.updateValue.setInt(4, orderNumber);
        return this.executeUpdate(this.updateValue, 2048);
    }

    @Override
    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties == null) {
            this.findNodesAndProperties = this.dbConnection.prepareStatement(this.FIND_NODES_AND_PROPERTIES);
        } else {
            this.findNodesAndProperties.clearParameters();
        }
        this.findNodesAndProperties.setString(1, lastNodeId);
        this.findNodesAndProperties.setInt(2, limit);
        this.findNodesAndProperties.setInt(3, offset);
        return this.findNodesAndProperties.executeQuery();
    }

    @Override
    protected ResultSet findACLHolders() throws SQLException {
        if (this.findACLHolders == null) {
            this.findACLHolders = this.dbConnection.prepareStatement(this.FIND_ACL_HOLDERS);
        }
        return this.findACLHolders.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteLockProperties() throws SQLException, RepositoryException {
        this.addChange(16);
        PreparedStatement findItemsStatement = null;
        Statement removeValueStatement = null;
        Statement removeItemStatement = null;
        ResultSet resultSet = null;
        try {
            findItemsStatement = this.dbConnection.prepareStatement("SELECT ID FROM " + this.JCR_ITEM + " WHERE I_CLASS = 2 AND  ( NAME = '[http://www.jcp.org/jcr/1.0]lockIsDeep' OR NAME = '[http://www.jcp.org/jcr/1.0]lockOwner' )");
            removeValueStatement = this.dbConnection.prepareStatement("DELETE FROM " + this.JCR_VALUE + " WHERE PROPERTY_ID = ?");
            removeItemStatement = this.dbConnection.prepareStatement("DELETE FROM " + this.JCR_ITEM + " WHERE ID = ? ");
            resultSet = findItemsStatement.executeQuery();
            while (resultSet.next()) {
                String id = resultSet.getString("ID");
                removeValueStatement.clearParameters();
                removeValueStatement.setString(1, id);
                removeValueStatement.executeUpdate();
                removeItemStatement.clearParameters();
                removeItemStatement.setString(1, id);
                removeItemStatement.executeUpdate();
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                }
            }
            if (findItemsStatement != null) {
                try {
                    findItemsStatement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't close statement", (Throwable)e);
                }
            }
            if (removeValueStatement != null) {
                try {
                    removeValueStatement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't close statement", (Throwable)e);
                }
            }
            if (removeItemStatement != null) {
                try {
                    removeItemStatement.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)"Can't close statement", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected ResultSet findNodesCount() throws SQLException {
        if (this.findNodesCount == null) {
            this.findNodesCount = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT);
        }
        return this.findNodesCount.executeQuery();
    }

    @Override
    protected ResultSet findMaxPropertyVersion(String parentId, String name, int index) throws SQLException {
        if (this.findMaxPropertyVersions == null) {
            this.findMaxPropertyVersions = this.dbConnection.prepareStatement(this.FIND_MAX_PROPERTY_VERSIONS);
        }
        this.findMaxPropertyVersions.setString(1, this.getInternalId(parentId));
        this.findMaxPropertyVersions.setString(2, name);
        this.findMaxPropertyVersions.setInt(3, index);
        return this.findMaxPropertyVersions.executeQuery();
    }

    @Override
    protected ResultSet findWorkspaceDataSize() throws SQLException {
        if (this.findWorkspaceDataSize == null) {
            this.findWorkspaceDataSize = this.dbConnection.prepareStatement(this.FIND_WORKSPACE_DATA_SIZE);
        }
        return this.findWorkspaceDataSize.executeQuery();
    }

    @Override
    protected ResultSet findWorkspacePropertiesOnValueStorage() throws SQLException {
        if (this.findWorkspacePropertiesOnValueStorage == null) {
            this.findWorkspacePropertiesOnValueStorage = this.dbConnection.prepareStatement(this.FIND_WORKSPACE_PROPERTIES_ON_VALUE_STORAGE);
        }
        return this.findWorkspacePropertiesOnValueStorage.executeQuery();
    }

    @Override
    protected ResultSet findNodeDataSize(String parentId) throws SQLException {
        if (this.findNodeDataSize == null) {
            this.findNodeDataSize = this.dbConnection.prepareStatement(this.FIND_NODE_DATA_SIZE);
        }
        this.findNodeDataSize.setString(1, parentId);
        return this.findNodeDataSize.executeQuery();
    }

    @Override
    protected ResultSet findNodePropertiesOnValueStorage(String parentId) throws SQLException {
        if (this.findNodePropertiesOnValueStorage == null) {
            this.findNodePropertiesOnValueStorage = this.dbConnection.prepareStatement(this.FIND_NODE_PROPERTIES_ON_VALUE_STORAGE);
        }
        this.findNodePropertiesOnValueStorage.setString(1, parentId);
        return this.findNodePropertiesOnValueStorage.executeQuery();
    }

    @Override
    protected ResultSet findValueStorageDescAndSize(String cid) throws SQLException {
        if (this.findValueStorageDescAndSize == null) {
            this.findValueStorageDescAndSize = this.dbConnection.prepareStatement(this.FIND_VALUE_STORAGE_DESC_AND_SIZE);
        }
        this.findValueStorageDescAndSize.setString(1, cid);
        return this.findValueStorageDescAndSize.executeQuery();
    }
}

