/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.fastcontentcreator.config;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.container.UIFormFieldSet;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCUtils;
import org.exoplatform.wcm.webui.fastcontentcreator.config.action.UIFCCActionList;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/FastContentCreatorPortlet/UIFormWithFieldSet.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeWorkspaceActionListener.class}, phase=Event.Phase.DECODE)})
public class UIFCCConfig
extends UIFormTabPane
implements UISelectable {
    private static final Log LOG = ExoLogger.getLogger((String)UIFCCConfig.class.getName());
    private static final String BASIC_MODE = "basic";
    private NodeLocation savedLocationNode;

    public UIFCCConfig() throws Exception {
        super("UIFCCConfig");
        PortletPreferences portletPreferences = UIFCCUtils.getPortletPreferences();
        String preferenceMode = portletPreferences.getValue("mode", "");
        String preferenceWorkspace = portletPreferences.getValue("workspace", "");
        String preferencePath = portletPreferences.getValue("path", "");
        ArrayList options = new ArrayList();
        UIFormInputSetWithAction saveLocationField = new UIFormInputSetWithAction("UIFCCSaveLocationField");
        if (!BASIC_MODE.equals(preferenceMode)) {
            UIFormSelectBox workspaceSelectBox = new UIFormSelectBox("UIFCCWorkspaceFormSelectBox", "UIFCCWorkspaceFormSelectBox", options);
            workspaceSelectBox.setOnChange("ChangeWorkspace");
            saveLocationField.addChild((UIComponent)workspaceSelectBox);
        }
        UIFormInputSetWithAction folderSelectorInput = new UIFormInputSetWithAction("UIFCCLocationFormInputAction");
        folderSelectorInput.addUIFormInput((UIFormInput)new UIFormStringInput("UIFCCLocationFormStringInput", "UIFCCLocationFormStringInput", null).setReadOnly(true));
        folderSelectorInput.setActionInfo("UIFCCLocationFormStringInput", new String[]{"SelectPath"});
        saveLocationField.addUIFormInput((UIFormInputSet)folderSelectorInput);
        this.addChild((UIComponent)saveLocationField);
        this.setSelectedTab("UIFCCSaveLocationField");
        UIFormInputSetWithAction templateField = new UIFormInputSetWithAction("UIFCCTemplateField");
        templateField.addChild((UIComponent)new UIFormSelectBox("UIFCCTemplateFormSelectBox", "UIFCCTemplateFormSelectBox", options));
        templateField.addChild((UIComponent)new UIFormStringInput("UIFCCSaveFormStringInput", "UIFCCSaveFormStringInput", null));
        templateField.addChild((UIComponent)new UIFormTextAreaInput("UIFCCMessageFormTextareaInput", "UIFCCMessageFormTextareaInput", null));
        templateField.addChild((UIComponent)new UICheckBoxInput("UIFCCRedirectFormCheckboxInput", "UIFCCRedirectFormCheckboxInput", Boolean.valueOf(false)));
        templateField.addChild((UIComponent)new UIFormStringInput("UIFCCRedirectPathFormStringInput", "UIFCCRedirectPathFormStringInput", null));
        this.addChild((UIComponent)templateField);
        if (!BASIC_MODE.equals(preferenceMode)) {
            UIFormInputSetWithAction actionField = new UIFormInputSetWithAction("UIFCCActionField");
            UIFCCActionList fastContentCreatorActionList = (UIFCCActionList)actionField.addChild(UIFCCActionList.class, null, "UIFCCActionList");
            fastContentCreatorActionList.init(preferenceMode);
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(preferenceWorkspace, WCMCoreUtils.getRepository());
            fastContentCreatorActionList.updateGrid((Node)session.getItem(preferencePath), ((UIGrid)fastContentCreatorActionList.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
            this.addChild((UIComponent)actionField);
        }
        this.setActions(new String[]{"Save"});
    }

    public void initEditMode() throws Exception {
        PortletPreferences preferences = UIFCCUtils.getPortletPreferences();
        String preferenceMode = preferences.getValue("mode", "");
        String preferenceWorkspace = preferences.getValue("workspace", "");
        String preferencePath = preferences.getValue("path", "");
        boolean isDefaultWorkspace = false;
        if (!BASIC_MODE.equals(preferenceMode)) {
            ManageableRepository repository = WCMCoreUtils.getRepository();
            String[] workspaceNames = repository.getWorkspaceNames();
            String systemWsName = repository.getConfiguration().getSystemWorkspaceName();
            ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
            for (String workspaceName : workspaceNames) {
                if (workspaceName.equals(systemWsName)) continue;
                if (workspaceName.equals(preferenceWorkspace)) {
                    isDefaultWorkspace = true;
                }
                workspace.add(new SelectItemOption((Object)workspaceName));
            }
            UIFormSelectBox uiWorkspaceList = this.getUIFormSelectBox("UIFCCWorkspaceFormSelectBox");
            uiWorkspaceList.setOptions(workspace);
            if (isDefaultWorkspace) {
                uiWorkspaceList.setValue(preferenceWorkspace);
            } else if (workspace.size() > 0) {
                uiWorkspaceList.setValue((String)((SelectItemOption)workspace.get(0)).getValue());
            }
        }
        this.getUIStringInput("UIFCCLocationFormStringInput").setValue((Object)preferencePath);
        this.setTemplateOptions(preferencePath, preferenceWorkspace);
        this.getUIStringInput("UIFCCSaveFormStringInput").setValue((Object)preferences.getValue("saveButton", ""));
        this.getUIFormTextAreaInput("UIFCCMessageFormTextareaInput").setValue((Object)preferences.getValue("saveMessage", ""));
        this.getUICheckBoxInput("UIFCCRedirectFormCheckboxInput").setChecked(Boolean.parseBoolean(preferences.getValue("isRedirect", "")));
        this.getUIStringInput("UIFCCRedirectPathFormStringInput").setValue((Object)preferences.getValue("redirectPath", ""));
    }

    private void setTemplateOptions(String nodePath, String workspaceName) throws Exception {
        try {
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspaceName, WCMCoreUtils.getRepository());
            Node currentNode = null;
            UIFormSelectBox uiSelectTemplate = this.getUIFormSelectBox("UIFCCTemplateFormSelectBox");
            ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
            boolean hasDefaultDoc = false;
            String defaultValue = UIFCCUtils.getPreferenceType();
            try {
                currentNode = (Node)session.getItem(nodePath);
                this.setSavedLocationNode(currentNode);
            }
            catch (PathNotFoundException ex) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIFCCConfig.msg.item-not-found", null, 1));
                return;
            }
            NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
            NodeType currentNodeType = currentNode.getPrimaryNodeType();
            NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            List templates = templateService.getDocumentTemplates();
            ArrayList<String> labels = new ArrayList<String>();
            try {
                block6: for (int i = 0; i < templates.size(); ++i) {
                    String nodeTypeName = ((String)templates.get(i)).toString();
                    NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                    NodeType[] superTypes = nodeType.getSupertypes();
                    boolean isCanCreateDocument = false;
                    for (NodeDefinition nodeDefinition : childDefs) {
                        String label;
                        NodeType[] requiredChilds;
                        NodeType[] nodeTypeArray = requiredChilds = nodeDefinition.getRequiredPrimaryTypes();
                        int n = nodeTypeArray.length;
                        for (int j = 0; j < n; ++j) {
                            NodeType requiredChild = nodeTypeArray[j];
                            if (!nodeTypeName.equals(requiredChild.getName())) continue;
                            isCanCreateDocument = true;
                            break;
                        }
                        if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                        if (!hasDefaultDoc && nodeTypeName.equals(defaultValue)) {
                            hasDefaultDoc = true;
                        }
                        if (!labels.contains(label = templateService.getTemplateLabel(nodeTypeName))) {
                            options.add(new SelectItemOption(label, (Object)nodeTypeName));
                        }
                        labels.add(label);
                        isCanCreateDocument = true;
                    }
                    if (isCanCreateDocument) continue;
                    for (NodeDefinition nodeDefinition : superTypes) {
                        for (NodeDefinition childDef : childDefs) {
                            for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                                String label;
                                if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                                if (!hasDefaultDoc && nodeTypeName.equals(defaultValue)) {
                                    hasDefaultDoc = true;
                                }
                                if (!labels.contains(label = templateService.getTemplateLabel(nodeTypeName))) {
                                    options.add(new SelectItemOption(label, (Object)nodeTypeName));
                                }
                                labels.add(label);
                                isCanCreateDocument = true;
                                break;
                            }
                            if (isCanCreateDocument) break;
                        }
                        if (isCanCreateDocument) continue block6;
                    }
                }
                uiSelectTemplate.setOptions(options);
                if (hasDefaultDoc) {
                    uiSelectTemplate.setValue(defaultValue);
                } else if (options.size() > 0) {
                    defaultValue = (String)((SelectItemOption)options.get(0)).getValue();
                    uiSelectTemplate.setValue(defaultValue);
                }
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)this, (String)"UIFCCConfig.msg.get-template", null, (int)0);
            }
        }
        catch (Exception ex) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIFCCConfig.msg.set-template-option", null, (int)0);
        }
    }

    public void doSelect(String selectField, Object value) {
        block9: {
            this.getUIStringInput(selectField).setValue((Object)value.toString());
            PortletPreferences preferences = UIFCCUtils.getPortletPreferences();
            String preferenceMode = preferences.getValue("mode", "");
            String preferenceWorkspace = preferences.getValue("workspace", "");
            if (!BASIC_MODE.equals(preferenceMode)) {
                preferenceWorkspace = (String)this.getUIFormSelectBox("UIFCCWorkspaceFormSelectBox").getValue();
            }
            String savedLocationPath = value.toString();
            try {
                this.setTemplateOptions(savedLocationPath, preferenceWorkspace);
            }
            catch (Exception ex) {
                Utils.createPopupMessage((UIContainer)this, (String)"UIFCCConfig.msg.do-select", null, (int)0);
            }
            try {
                Session session = WCMCoreUtils.getUserSessionProvider().getSession(preferenceWorkspace, WCMCoreUtils.getRepository());
                UIFCCActionList uiFCCActionList = (UIFCCActionList)((UIFormFieldSet)this.getChildById("UIFCCActionField")).getChild(UIFCCActionList.class);
                uiFCCActionList.updateGrid((Node)session.getItem(savedLocationPath), ((UIGrid)uiFCCActionList.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
            }
            catch (RepositoryConfigurationException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            catch (RepositoryException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)e.getMessage());
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block9;
                LOG.warn((Object)e.getMessage());
            }
        }
        Utils.closePopupWindow((UIContainer)this, (String)"UIFCCSelectorPopupWindow");
    }

    public Node getSavedLocationNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.savedLocationNode);
    }

    public void setSavedLocationNode(Node savedLocationNode) {
        this.savedLocationNode = NodeLocation.getNodeLocationByNode((Node)savedLocationNode);
    }

    public String getPreferenceMode() {
        PortletPreferences portletPreferences = UIFCCUtils.getPortletPreferences();
        return portletPreferences.getValue("mode", "");
    }

    public static class SaveActionListener
    extends EventListener<UIFCCConfig> {
        public void execute(Event<UIFCCConfig> event) throws Exception {
            UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)fastContentCreatorConfig.getAncestorOfType(UIApplication.class);
            PortletPreferences portletPreferences = UIFCCUtils.getPortletPreferences();
            String preferenceMode = portletPreferences.getValue("mode", "");
            boolean preferenceIsActionNeeded = Boolean.parseBoolean(portletPreferences.getValue("isActionNeeded", "false"));
            String type = (String)fastContentCreatorConfig.getUIFormSelectBox("UIFCCTemplateFormSelectBox").getValue();
            String path = (String)fastContentCreatorConfig.getUIStringInput("UIFCCLocationFormStringInput").getValue();
            String saveButton = (String)fastContentCreatorConfig.getUIStringInput("UIFCCSaveFormStringInput").getValue();
            String saveMessage = (String)fastContentCreatorConfig.getUIFormTextAreaInput("UIFCCMessageFormTextareaInput").getValue();
            String isRedirect = String.valueOf(fastContentCreatorConfig.getUICheckBoxInput("UIFCCRedirectFormCheckboxInput").isChecked());
            String redirectPath = (String)fastContentCreatorConfig.getUIStringInput("UIFCCRedirectPathFormStringInput").getValue();
            if (("false".equals(isRedirect) || redirectPath == null) && saveMessage == null) {
                Utils.createPopupMessage((UIContainer)fastContentCreatorConfig, (String)"UIFCCConfig.msg.message-empty", null, (int)1);
            }
            String workspaceName = null;
            workspaceName = UIFCCConfig.BASIC_MODE.equals(preferenceMode) && preferenceIsActionNeeded ? portletPreferences.getValue("workspace", "") : (String)fastContentCreatorConfig.getUIFormSelectBox("UIFCCWorkspaceFormSelectBox").getValue();
            if (workspaceName == null || workspaceName.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIFCCConfig.msg.ws-empty", null, 1));
                return;
            }
            if (type == null || type.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIFCCConfig.msg.fileType-empty", null, 1));
                return;
            }
            portletPreferences.setValue("workspace", workspaceName);
            portletPreferences.setValue("path", path);
            portletPreferences.setValue("type", type);
            portletPreferences.setValue("saveButton", saveButton);
            portletPreferences.setValue("saveMessage", saveMessage);
            portletPreferences.setValue("isRedirect", isRedirect);
            portletPreferences.setValue("redirectPath", redirectPath);
            portletPreferences.store();
            uiApp.addMessage(new ApplicationMessage("UIFCCConfig.msg.save-successfully", null));
        }
    }

    public static class ChangeWorkspaceActionListener
    extends EventListener<UIFCCConfig> {
        public void execute(Event<UIFCCConfig> event) throws Exception {
            UIFCCConfig uiFCCConfig = (UIFCCConfig)((Object)event.getSource());
            uiFCCConfig.getUIStringInput("UIFCCLocationFormStringInput").setValue((Object)"/");
            String wsName = (String)uiFCCConfig.getUIFormSelectBox("UIFCCWorkspaceFormSelectBox").getValue();
            uiFCCConfig.setTemplateOptions((String)uiFCCConfig.getUIStringInput("UIFCCLocationFormStringInput").getValue(), wsName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiFCCConfig);
        }
    }

    public static class SelectPathActionListener
    extends EventListener<UIFCCConfig> {
        public void execute(Event<UIFCCConfig> event) throws Exception {
            UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)((Object)event.getSource());
            PortletPreferences preferences = UIFCCUtils.getPortletPreferences();
            String preferenceMode = preferences.getValue("mode", "");
            String preferenceRepository = WCMCoreUtils.getRepository().getConfiguration().getName();
            String preferenceWorkspace = preferences.getValue("workspace", "");
            if (!UIFCCConfig.BASIC_MODE.equals(preferenceMode)) {
                preferenceWorkspace = (String)fastContentCreatorConfig.getUIFormSelectBox("UIFCCWorkspaceFormSelectBox").getValue();
            }
            UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)fastContentCreatorConfig.createUIComponent(UIOneNodePathSelector.class, null, null);
            uiOneNodePathSelector.setIsDisable(preferenceWorkspace, true);
            uiOneNodePathSelector.setShowRootPathSelect(true);
            uiOneNodePathSelector.setRootNodeLocation(preferenceRepository, preferenceWorkspace, "/");
            uiOneNodePathSelector.init(WCMCoreUtils.getUserSessionProvider());
            uiOneNodePathSelector.setSourceComponent((UIComponent)fastContentCreatorConfig, new String[]{"UIFCCLocationFormStringInput"});
            Utils.createPopupWindow((UIContainer)fastContentCreatorConfig, (UIComponent)uiOneNodePathSelector, (String)"UIFCCSelectorPopupWindow", (int)610);
            fastContentCreatorConfig.setSelectedTab("UIFCCSaveLocationField");
        }
    }
}

