/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import javax.measure.spi.UnitFormatService;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.logging.Logging;

public class UnitServices
extends ServiceProvider
implements SystemOfUnitsService,
UnitFormatService {
    private final UnitRegistry[] systems = new UnitRegistry[]{new UnitRegistry("SI", 2), new UnitRegistry("SI + accepted", 6), new UnitRegistry("Imperial", 8), new UnitRegistry("SI + other", -1)};

    public SystemOfUnits getSystemOfUnits() {
        return this.systems[this.systems.length - 1];
    }

    public SystemOfUnits getSystemOfUnits(String string) {
        ArgumentChecks.ensureNonEmpty("name", string);
        for (UnitRegistry unitRegistry : this.systems) {
            if (!CharSequences.equalsFiltered(unitRegistry.name, string, Characters.Filter.UNICODE_IDENTIFIER, true)) continue;
            return unitRegistry;
        }
        return null;
    }

    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return UnmodifiableArrayList.wrap(this.systems);
    }

    public SystemOfUnitsService getSystemOfUnitsService() {
        return this;
    }

    public javax.measure.format.UnitFormat getUnitFormat() {
        return new UnitFormat(Locale.getDefault(Locale.Category.FORMAT));
    }

    public javax.measure.format.UnitFormat getUnitFormat(String string) {
        UnitFormat.Style style;
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        string = string.toUpperCase(locale).trim();
        try {
            style = UnitFormat.Style.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.recoverableException(Logging.getLogger("org.apache.sis.measure"), UnitServices.class, "getUnitFormat", illegalArgumentException);
            return null;
        }
        UnitFormat unitFormat = new UnitFormat(locale);
        unitFormat.setStyle(style);
        return unitFormat;
    }

    public Set<String> getAvailableFormatNames() {
        HashSet<String> hashSet = new HashSet<String>(4);
        for (UnitFormat.Style style : UnitFormat.Style.values()) {
            hashSet.add(style.name());
        }
        return hashSet;
    }

    public UnitFormatService getUnitFormatService() {
        return this;
    }

    public <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(final Class<Q> clazz) {
        SystemUnit<Q> systemUnit = Units.get(clazz);
        if (systemUnit == null) {
            systemUnit = new QuantityFactory<Q>(){

                public Quantity<Q> create(Number number, Unit<Q> unit) {
                    return ScalarFallback.factory(AbstractConverter.doubleValue(number), unit, clazz);
                }

                public Unit<Q> getSystemUnit() {
                    return null;
                }
            };
        }
        return systemUnit;
    }
}

