/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocaleConfigServiceImpl
implements LocaleConfigService {
    private static Log log = ExoLogger.getLogger(LocaleConfigServiceImpl.class);
    private DocumentBuilderFactory factory;
    private LocaleConfig defaultConfig_;
    private Map<String, LocaleConfig> configs_ = new HashMap<String, LocaleConfig>(10);
    private static final Map<String, Orientation> orientations = new HashMap<String, Orientation>();

    public LocaleConfigServiceImpl(InitParams params, ConfigurationManager cmanager) throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        String confResource = params.getValueParam("locale.config.file").getValue();
        InputStream is = cmanager.getInputStream(confResource);
        this.parseConfiguration(is);
    }

    public LocaleConfig getDefaultLocaleConfig() {
        return this.defaultConfig_;
    }

    public LocaleConfig getLocaleConfig(String lang) {
        LocaleConfig config = this.configs_.get(lang);
        if (config != null) {
            return config;
        }
        return this.defaultConfig_;
    }

    public Collection<LocaleConfig> getLocalConfigs() {
        return this.configs_.values();
    }

    protected void parseConfiguration(InputStream is) throws Exception {
        this.factory.setIgnoringComments(true);
        this.factory.setCoalescing(true);
        this.factory.setNamespaceAware(false);
        this.factory.setValidating(false);
        DocumentBuilder parser = this.factory.newDocumentBuilder();
        Document document = parser.parse(is);
        NodeList nodes = document.getElementsByTagName("locale-config");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            NodeList children = node.getChildNodes();
            LocaleConfigImpl config = new LocaleConfigImpl();
            for (int j = 0; j < children.getLength(); ++j) {
                Node element = children.item(j);
                if ("locale".equals(element.getNodeName())) {
                    config.setLocale(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("output-encoding".equals(element.getNodeName())) {
                    config.setOutputEncoding(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("input-encoding".equals(element.getNodeName())) {
                    config.setInputEncoding(element.getFirstChild().getNodeValue());
                    continue;
                }
                if ("description".equals(element.getNodeName())) {
                    config.setDescription(element.getFirstChild().getNodeValue());
                    continue;
                }
                if (!"orientation".equals(element.getNodeName())) continue;
                String s = element.getFirstChild().getNodeValue();
                Orientation orientation = orientations.get(s);
                if (orientation == null) {
                    log.error((Object)("Wrong orientation value " + s));
                    continue;
                }
                config.setOrientation(orientation);
            }
            if (config.getOrientation() == null) {
                log.debug((Object)"No orientation found on the locale config, use the LT default");
                config.setOrientation(Orientation.LT);
            }
            log.debug((Object)("Added locale config " + config + " to the set of locale configs"));
            String country = config.getLocale().getCountry();
            if (country != null && country.length() > 0) {
                this.configs_.put(config.getLanguage() + "_" + country, config);
            } else {
                this.configs_.put(config.getLanguage(), config);
            }
            if (i != 0) continue;
            this.defaultConfig_ = config;
        }
        if (PropertyManager.isDevelopping()) {
            LocaleConfigImpl magicConfig = new LocaleConfigImpl();
            magicConfig.setLocale(IdentityResourceBundle.MAGIC_LOCALE);
            magicConfig.setDescription("Magic locale");
            magicConfig.setInputEncoding("UTF-8");
            magicConfig.setOutputEncoding("UTF-8");
            magicConfig.setDescription("Default configuration for the debugging locale");
            magicConfig.setOrientation(Orientation.LT);
            this.configs_.put(magicConfig.getLanguage(), magicConfig);
            log.debug((Object)"Added magic locale for debugging bundle usage at runtime");
        }
    }

    static {
        orientations.put("lt", Orientation.LT);
        orientations.put("rt", Orientation.RT);
        orientations.put("tl", Orientation.TL);
        orientations.put("tr", Orientation.TR);
    }
}

