/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardPeriodWithFullDate;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.exoplatform.wallet.reward.service.RewardSettingsService;
import org.exoplatform.wallet.utils.RewardUtils;
import org.exoplatform.wallet.utils.WalletUtils;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/wallet/api/reward/")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/reward", description="Manage wallet rewards")
public class RewardReportREST
implements ResourceContainer {
    private static final String ERROR_PARAM = "error";
    private static final Log LOG = ExoLogger.getLogger(RewardReportREST.class);
    private RewardReportService rewardReportService;
    private RewardSettingsService rewardSettingsService;

    public RewardReportREST(RewardReportService rewardReportService, RewardSettingsService rewardSettingsService) {
        this.rewardReportService = rewardReportService;
        this.rewardSettingsService = rewardSettingsService;
    }

    @GET
    @Path(value="compute")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Compute rewards of wallets per a chosen period of time", httpMethod="GET", response=Response.class, produces="application/json", notes="returns a set of wallet reward object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response computeRewards(@ApiParam(value="A date with format yyyy-MM-dd", required=true) @QueryParam(value="date") String date) {
        if (StringUtils.isBlank((String)date)) {
            return Response.status((int)400).entity((Object)"Bad request sent to server with empty 'date' parameter").build();
        }
        try {
            RewardPeriod rewardPeriod = this.getRewardPeriod(date);
            RewardReport rewardReport = this.rewardReportService.computeRewards(rewardPeriod.getPeriodMedianDate());
            rewardReport.setPeriod(new RewardPeriodWithFullDate(rewardReport.getPeriod()));
            return Response.ok((Object)rewardReport).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append(ERROR_PARAM, (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="send")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Send rewards of wallets per a chosen period of time", httpMethod="GET", response=Response.class, notes="return empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response sendRewards(@ApiParam(value="A date with format yyyy-MM-dd", required=true) @QueryParam(value="date") String date) {
        try {
            if (StringUtils.isBlank((String)date)) {
                return Response.status((int)400).entity((Object)"Bad request sent to server with empty 'date' parameter").build();
            }
            RewardPeriod rewardPeriod = this.getRewardPeriod(date);
            this.rewardReportService.sendRewards(rewardPeriod.getPeriodMedianDate(), WalletUtils.getCurrentUserId());
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append(ERROR_PARAM, (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="list")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Return list of rewards for current user with a limit of items to return", httpMethod="GET", produces="application/json", response=Response.class, notes="return list of rewards per user")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response listRewards(@ApiParam(value="limit of items to load", required=false) @QueryParam(value="limit") int limit) {
        try {
            List<WalletReward> rewards = this.rewardReportService.listRewards(WalletUtils.getCurrentUserId(), limit);
            rewards.forEach(reward -> reward.setPeriod(new RewardPeriodWithFullDate(reward.getPeriod())));
            return Response.ok(rewards).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting list of reward for current user", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append(ERROR_PARAM, (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="countRewards")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Return sum of rewards for user", httpMethod="GET", produces="application/json", response=Response.class, notes="return sum of rewards per user")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response countRewards(@Context Request request, @ApiParam(value="user id", required=true) @QueryParam(value="userId") String userId) {
        try {
            Double sumRewards = this.rewardReportService.countRewards(userId);
            EntityTag eTag = new EntityTag(String.valueOf(sumRewards));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                JSONObject result = new JSONObject();
                result.put("sumRewards", (Object)sumRewards);
                builder = Response.ok((Object)result.toString(), (String)"application/json");
                builder.tag(eTag);
            }
            return builder.build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting sum of reward for current user", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append(ERROR_PARAM, (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    private RewardPeriod getRewardPeriod(String date) {
        RewardSettings settings = this.rewardSettingsService.getSettings();
        ZoneId zoneId = settings.zoneId();
        RewardPeriodType rewardPeriodType = settings.getPeriodType();
        ZonedDateTime zonedDateTime = RewardUtils.parseRFC3339ToZonedDateTime(date, zoneId);
        return rewardPeriodType.getPeriodOfTime(zonedDateTime);
    }
}

