/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.Unit;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.Static;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;

public final class NameMeaning
extends Static {
    private static final Class<?>[] CLASSES = new Class[]{CoordinateReferenceSystem.class, Datum.class, Ellipsoid.class, PrimeMeridian.class, CoordinateSystem.class, CoordinateSystemAxis.class, CoordinateOperation.class, OperationMethod.class, ParameterDescriptor.class, ReferenceSystem.class, Unit.class};
    private static final String[] TYPES = new String[]{"crs", "datum", "ellipsoid", "meridian", "cs", "axis", "coordinateOperation", "method", "parameter", "referenceSystem", "uom"};
    private static final Map<String, String> AUTHORITIES = new HashMap<String, String>(12);

    private static void add(String string) {
        AUTHORITIES.put(string, string);
    }

    private NameMeaning() {
    }

    public static String toURN(Class<?> clazz, String string, String string2, String string3) {
        Object object;
        if (clazz == null || string == null || string3 == null) {
            return null;
        }
        String string4 = string.toUpperCase(Locale.US);
        String string5 = AUTHORITIES.get(string4);
        if (string5 == null) {
            object = Citations.fromName(string4);
            string5 = Citations.toCodeSpace((Citation)object);
            if (AUTHORITIES.get(string5) == null) {
                return null;
            }
            string2 = NameMeaning.getVersion((Citation)object);
            if (!string.equals(string5) && !string3.startsWith(string)) {
                string3 = string + string3;
            }
        }
        object = new StringBuilder("urn:ogc:def");
        int n = 0;
        block6: while (true) {
            String string6;
            switch (n) {
                case 0: {
                    string6 = NameMeaning.toObjectType(clazz);
                    break;
                }
                case 1: {
                    string6 = string5;
                    break;
                }
                case 2: {
                    string6 = string2;
                    break;
                }
                case 3: {
                    string6 = string3;
                    break;
                }
                default: {
                    break block6;
                }
            }
            if (!Strings.appendUnicodeIdentifier((StringBuilder)((StringBuilder)object).append(':'), (char)'\u0000', (String)string6, (String)".-", (boolean)false) && n != 2) {
                return null;
            }
            ++n;
        }
        return ((StringBuilder)object).toString();
    }

    public static String toObjectType(Class<?> clazz) {
        for (int i = 0; i < CLASSES.length; ++i) {
            if (!CLASSES[i].isAssignableFrom(clazz)) continue;
            return TYPES[i];
        }
        return null;
    }

    public static String getVersion(Citation citation) {
        InternationalString internationalString;
        if (citation != null && (internationalString = citation.getEdition()) != null) {
            return internationalString.toString(Locale.US);
        }
        return null;
    }

    static {
        NameMeaning.add("EPSG");
        NameMeaning.add("OGC");
        NameMeaning.add("OGC-WFS");
        NameMeaning.add("SI");
        NameMeaning.add("UCUM");
        NameMeaning.add("UNSD");
        NameMeaning.add("USNO");
    }
}

