/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;

public final class RasterFactory
extends Static {
    private RasterFactory() {
    }

    public static WritableRaster createRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        ComponentSampleModel componentSampleModel;
        int n5 = dataBuffer.getDataType();
        if (dataBuffer.getNumBanks() == 1 && (nArray == null || nArray[0] == 0)) {
            switch (n5) {
                case 0: 
                case 1: {
                    return WritableRaster.createInterleavedRaster(dataBuffer, n, n2, n4, n3, nArray2, point);
                }
                case 3: {
                    if (nArray2.length != 1 || n3 != 1) break;
                    return WritableRaster.createBandedRaster(dataBuffer, n, n2, n4, new int[1], nArray2, point);
                }
            }
            componentSampleModel = new PixelInterleavedSampleModel(n5, n, n2, n3, n4, nArray2);
        } else {
            if (nArray == null) {
                nArray = ArraysExt.range((int)0, (int)nArray2.length);
            }
            if (n3 == 1) {
                switch (n5) {
                    case 0: 
                    case 1: 
                    case 3: {
                        return WritableRaster.createBandedRaster(dataBuffer, n, n2, n4, nArray, nArray2, point);
                    }
                }
                componentSampleModel = new BandedSampleModel(n5, n, n2, n4, nArray, nArray2);
            } else {
                componentSampleModel = new ComponentSampleModel(n5, n, n2, n3, n4, nArray, nArray2);
            }
        }
        return WritableRaster.createWritableRaster(componentSampleModel, dataBuffer, point);
    }

    public static int getType(Class<?> clazz, boolean bl) {
        switch (Numbers.getEnumConstant(clazz)) {
            case 3: {
                if (!bl) break;
                return 0;
            }
            case 4: {
                return bl ? 1 : 2;
            }
            case 5: {
                if (bl) break;
                return 3;
            }
            case 8: {
                return 4;
            }
            case 9: {
                return 5;
            }
        }
        return 32;
    }

    public static DataBuffer wrap(int n, Buffer ... bufferArray) {
        Object object;
        int n2 = bufferArray.length;
        switch (n) {
            case 1: 
            case 2: {
                object = new short[n2][];
                break;
            }
            case 3: {
                object = new int[n2][];
                break;
            }
            case 0: {
                object = new byte[n2][];
                break;
            }
            case 4: {
                object = new float[n2][];
                break;
            }
            case 5: {
                object = new double[n2][];
                break;
            }
            default: {
                return null;
            }
        }
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Buffer buffer = bufferArray[i];
            ArgumentChecks.ensureNonNullElement((String)"data", (int)i, (Object)buffer);
            object[i] = (short[])buffer.array();
            nArray[i] = Math.addExact(buffer.arrayOffset(), buffer.position());
            int n4 = buffer.remaining();
            if (i == 0) {
                n3 = n4;
                continue;
            }
            if (n3 == n4) continue;
            throw new RasterFormatException(Resources.format((short)38));
        }
        switch (n) {
            case 0: {
                return new DataBufferByte((byte[][])object, n3, nArray);
            }
            case 2: {
                return new DataBufferShort((short[][])object, n3, nArray);
            }
            case 1: {
                return new DataBufferUShort((short[][])object, n3, nArray);
            }
            case 3: {
                return new DataBufferInt((int[][])object, n3, nArray);
            }
            case 4: {
                return new DataBufferFloat((float[][])object, n3, nArray);
            }
            case 5: {
                return new DataBufferDouble((double[][])object, n3, nArray);
            }
        }
        return null;
    }
}

