/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.index;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.search.index.IndexingServiceConnector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class IndexingOperationProcessor {
    private static final Log LOG = ExoLogger.getExoLogger(IndexingOperationProcessor.class);
    private Map<String, IndexingServiceConnector> connectors = new HashMap<String, IndexingServiceConnector>();

    public void addConnector(IndexingServiceConnector indexingServiceConnector) {
        this.addConnector(indexingServiceConnector, false);
    }

    public void addConnector(IndexingServiceConnector indexingServiceConnector, Boolean override) {
        if (this.connectors.containsKey(indexingServiceConnector.getConnectorName()) && override.equals(false)) {
            LOG.error("Impossible to add connector {}. A connector with the same name has already been registered.", new Object[]{indexingServiceConnector.getConnectorName()});
        } else {
            this.connectors.put(indexingServiceConnector.getConnectorName(), indexingServiceConnector);
            LOG.info("An Indexing Connector has been added: {}", new Object[]{indexingServiceConnector.getConnectorName()});
        }
    }

    public Map<String, IndexingServiceConnector> getConnectors() {
        return this.connectors;
    }

    public abstract void process();

    public abstract void interrupt();
}

