/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class RelationshipNotificationImpl
extends RelationshipListenerPlugin {
    private WebNotificationService webNotificationService;
    private static final Log LOG = ExoLogger.getLogger(RelationshipNotificationImpl.class);

    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        String receiverId = relationship.getReceiver().getRemoteId();
        String senderId = relationship.getSender().getRemoteId();
        this.markAllInvitationNotificationsAsAccepted(senderId, receiverId);
    }

    public void ignored(RelationshipEvent event) {
    }

    public void removed(RelationshipEvent event) {
    }

    public void requested(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.RELATIONSHIP, (Object)relationship);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RelationshipReceivedRequestPlugin"))).execute(ctx);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get invite to connect information of " + event + ": " + e.getMessage()));
        }
    }

    public void denied(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        String receiverId = relationship.getReceiver().getRemoteId();
        String senderId = relationship.getSender().getRemoteId();
        this.removeAllDeniedInvitationsNotifications(senderId, receiverId);
    }

    private void markAllInvitationNotificationsAsAccepted(String senderId, String receiverId) {
        WebNotificationService webNotificationService = this.getWebNotificationService();
        if (webNotificationService != null) {
            WebNotificationFilter webNotificationFilter = new WebNotificationFilter(receiverId);
            webNotificationFilter.setParameter("sender", senderId);
            PluginKey pluginKey = new PluginKey("RelationshipReceivedRequestPlugin");
            webNotificationFilter.setPluginKey(pluginKey);
            List webNotifs = webNotificationService.getNotificationInfos(webNotificationFilter, 0, -1);
            HashMap<String, String> ownerParameter = new HashMap<String, String>();
            ownerParameter.put("status", "accepted");
            ownerParameter.put("sender", senderId);
            for (NotificationInfo info : webNotifs) {
                info.setOwnerParameter(ownerParameter);
                info.key(pluginKey);
                info.setFrom(senderId);
                info.setTo(receiverId);
                this.updateNotification(info);
            }
        } else {
            LOG.error((Object)"Cannot update web notfication. WebNotificationService is null");
        }
    }

    private void removeAllDeniedInvitationsNotifications(String senderId, String receiverId) {
        WebNotificationService webNotificationService = this.getWebNotificationService();
        if (webNotificationService != null) {
            WebNotificationFilter webNotificationFilter = new WebNotificationFilter(receiverId);
            webNotificationFilter.setParameter("sender", senderId);
            PluginKey pluginKey = new PluginKey("RelationshipReceivedRequestPlugin");
            webNotificationFilter.setPluginKey(pluginKey);
            List webNotifs = webNotificationService.getNotificationInfos(webNotificationFilter, 0, -1);
            for (NotificationInfo notificationInfo : webNotifs) {
                webNotificationService.remove(notificationInfo.getId());
            }
        } else {
            LOG.error((Object)"Cannot update web notfication. WebNotificationService is null");
        }
    }

    private WebNotificationService getWebNotificationService() {
        if (this.webNotificationService == null) {
            this.webNotificationService = (WebNotificationService)CommonsUtils.getService(WebNotificationService.class);
        }
        return this.webNotificationService;
    }

    private MessageInfo updateNotification(NotificationInfo notification) {
        NotificationContext nCtx = NotificationContextImpl.cloneInstance().setNotificationInfo(notification);
        BaseNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin == null) {
            return null;
        }
        try {
            AbstractChannel channel = nCtx.getChannelManager().getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
            AbstractTemplateBuilder builder = channel.getTemplateBuilder(notification.getKey());
            MessageInfo msg = builder.buildMessage(nCtx);
            msg.setMoveTop(false);
            WebNotificationSender.sendJsonMessage((String)notification.getTo(), (MessageInfo)msg);
            notification.setTitle(msg.getBody());
            notification.with(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey(), "true").with(NotificationMessageUtils.READ_PORPERTY.getKey(), "false");
            this.getWebNotificationService().save(notification);
            return msg;
        }
        catch (Exception e) {
            LOG.error("Can not update relationship notification.", new Object[]{e.getMessage()});
            return null;
        }
    }
}

