/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.lang.reflect.Method;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageCreationWizard;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.page.UIWizardPageSetInfo;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIMainActionListener {

    public static class EditBackgroundActionListener
    extends EventListener<UIWorkingWorkspace> {
        private Log log = ExoLogger.getExoLogger(((Object)((Object)this)).getClass());

        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UIWorkingWorkspace workingWorkspace = (UIWorkingWorkspace)((Object)event.getSource());
            UIPage uiPage = (UIPage)workingWorkspace.findFirstComponentOfType(UIPage.class);
            Method showEditBackgroundPopupMethod = null;
            try {
                if (uiPage == null) {
                    return;
                }
                showEditBackgroundPopupMethod = ((Object)((Object)uiPage)).getClass().getDeclaredMethod("showEditBackgroundPopup", WebuiRequestContext.class);
            }
            catch (NoSuchMethodException ex) {
                this.log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            if (showEditBackgroundPopupMethod != null) {
                showEditBackgroundPopupMethod.invoke((Object)uiPage, event.getRequestContext());
            }
        }
    }

    public static class CreatePortalActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiApp = (UIPortalApplication)((UIWorkingWorkspace)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UserACL userACL = (UserACL)uiApp.getApplicationComponent(UserACL.class);
            if (!userACL.hasCreatePortalPermission()) {
                uiApp.addMessage(new ApplicationMessage("UIPortalBrowser.msg.Invalid-createPermission", null));
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm uiNewPortal = uiMaskWS.createUIComponent(UIPortalForm.class, "CreatePortal", "UIPortalForm");
            uiNewPortal.initPortalTemplateTab();
            uiMaskWS.setUIComponent((UIComponent)uiNewPortal);
            uiMaskWS.setShow(true);
            prContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    public static class EditPageInFullPreviewActionListener
    extends EditInlineActionListener {
        @Override
        public boolean authorizeEditSite(UIPortal currentPortal, UIPortalApplication portalApp) {
            return true;
        }

        @Override
        public boolean authorizeEditPage(UIPortal currentPortal, UIPortalApplication portalApp) {
            UIPage uiPage;
            SiteKey siteKey;
            UserACL userACL = (UserACL)currentPortal.getApplicationComponent(UserACL.class);
            if (userACL.hasEditPermissionOnPage((siteKey = (uiPage = (UIPage)currentPortal.findFirstComponentOfType(UIPage.class)).getSiteKey()).getTypeName(), siteKey.getName(), uiPage.getEditPermission())) {
                return true;
            }
            portalApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditPage-Permission", null));
            return false;
        }

        @Override
        protected void configureComposer(UIPortalComposer uiComposer) {
            uiComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
            uiComposer.setId("UIPageEditor");
        }

        @Override
        protected UIPortalApplication.EditLevel getEditLevel() {
            return UIPortalApplication.EditLevel.EDIT_PAGE;
        }

        @Override
        protected void configurePortal(UIPortalApplication portalApp, UIPortal transientPortal) {
            if (portalApp.getEditMode() == UIPortalApplication.EditMode.BLOCK) {
                transientPortal.setHeaderAndFooterRendered(false);
            }
        }
    }

    public static class EditInlineActionListener
    extends EventListener<UIWorkingWorkspace> {
        protected boolean authorizeEditSite(UIPortal currentPortal, UIPortalApplication portalApp) {
            UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
            if (userACL.hasEditPermissionOnPortal(currentPortal.getSiteType().getName(), currentPortal.getName(), currentPortal.getEditPermission())) {
                return true;
            }
            portalApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-EditLayout-Permission", (Object[])new String[]{currentPortal.getName()}));
            return false;
        }

        protected boolean authorizeEditPage(UIPortal currentPortal, UIPortalApplication portalApp) {
            return true;
        }

        protected void configureComposer(UIPortalComposer uiComposer) {
            uiComposer.setComponentConfig(UIPortalComposer.class, null);
            uiComposer.setId("UIPortalComposer");
        }

        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPortalApplication portalApp = (UIPortalApplication)pcontext.getUIApplication();
            UIPortal currentPortal = portalApp.getCurrentSite();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)((Object)event.getSource());
            if (this.authorizeEditSite(currentPortal, portalApp)) {
                PortalConfig portalConfig = pcontext.getDynamicPortalConfig();
                UIPortal transientPortal = (UIPortal)uiWorkingWS.createUIComponent(UIPortal.class, null, null);
                PortalDataMapper.toUIPortal(transientPortal, portalConfig);
                transientPortal.setNavPath(currentPortal.getNavPath());
                transientPortal.refreshUIPage();
                if (this.authorizeEditPage(currentPortal, portalApp)) {
                    uiWorkingWS.setBackupUIPortal(currentPortal);
                    portalApp.setDefaultEditMode(UIPortalApplication.ComponentTab.APPLICATIONS, this.getEditLevel());
                    this.configurePortal(portalApp, transientPortal);
                    UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
                    uiEditWS.setUIComponent((UIComponent)transientPortal);
                    UISiteBody siteBody = (UISiteBody)uiWorkingWS.findFirstComponentOfType(UISiteBody.class);
                    siteBody.setUIComponent(null);
                    UIPortalComposer uiComposer = (UIPortalComposer)uiEditWS.getComposer().setRendered(true);
                    this.configureComposer(uiComposer);
                    uiComposer.setShowControl(true);
                    uiComposer.setEditted(false);
                    uiComposer.setCollapse(false);
                    uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
                    pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                    pcontext.ignoreAJAXUpdateOnPortlets(true);
                }
            }
        }

        protected void configurePortal(UIPortalApplication portalApp, UIPortal transientPortal) {
        }

        protected UIPortalApplication.EditLevel getEditLevel() {
            return UIPortalApplication.EditLevel.EDIT_SITE;
        }
    }

    public static class PageCreationWizardActionListener
    extends EventListener<UIWorkingWorkspace> {
        public void execute(Event<UIWorkingWorkspace> event) throws Exception {
            UserNodeFilterConfig filterConfig;
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            UIPortal uiPortal = Util.getUIPortal();
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiApp.getChildById("UIWorkingWorkspace");
            UserNavigation currNav = uiPortal.getUserNavigation();
            if (currNav == null) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.navigation.deleted", null));
                return;
            }
            if (!currNav.isModifiable()) {
                uiApp.addMessage(new ApplicationMessage("UIPortalManagement.msg.Invalid-CreatePage-Permission", null));
                return;
            }
            UserNode selectedNode = Util.getUIPortal().getSelectedUserNode();
            UserNode resolvedNode = this.resolveNode(selectedNode, filterConfig = this.createFilterConfig());
            if (resolvedNode == null) {
                resolvedNode = this.resolveNode(selectedNode, null);
                WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                if (resolvedNode == null) {
                    context.getUIApplication().addMessage(new ApplicationMessage("UIPortalManagement.msg.node.deleted", null));
                } else {
                    context.getUIApplication().addMessage(new ApplicationMessage("UIPortalManagement.msg.node.permission", null));
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                return;
            }
            uiApp.setDefaultEditMode(UIPortalApplication.ComponentTab.APPLICATIONS, UIPortalApplication.EditLevel.EDIT_PAGE);
            uiWorkingWS.setRenderedChild(UIEditInlineWorkspace.class);
            UIPortalComposer portalComposer = (UIPortalComposer)uiWorkingWS.findFirstComponentOfType(UIPortalComposer.class);
            portalComposer.setRendered(false);
            portalComposer.setComponentConfig(UIPortalComposer.class, "UIPageEditor");
            portalComposer.setId("UIPageEditor");
            portalComposer.setShowControl(true);
            portalComposer.setEditted(true);
            portalComposer.setCollapse(false);
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(false);
            uiToolPanel.setWorkingComponent(UIPageCreationWizard.class, null);
            UIPageCreationWizard uiWizard = (UIPageCreationWizard)uiToolPanel.getUIComponent();
            uiWizard.configure(resolvedNode);
            UIWizardPageSetInfo uiPageSetInfo = (UIWizardPageSetInfo)uiWizard.getChild(UIWizardPageSetInfo.class);
            uiPageSetInfo.setShowPublicationDate(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        }

        private UserNode resolveNode(UserNode selectedNode, UserNodeFilterConfig filterConfig) {
            UserNavigation currNav = selectedNode.getNavigation();
            UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
            if (currNav.getKey().getType().equals((Object)SiteType.USER)) {
                return userPortal.getNode(currNav, Scope.CHILDREN, filterConfig, null);
            }
            return userPortal.resolvePath(currNav, filterConfig, selectedNode.getURI());
        }

        private UserNodeFilterConfig createFilterConfig() {
            UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
            filterConfigBuilder.withReadWriteCheck();
            return filterConfigBuilder.build();
        }
    }
}

