/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.commandline;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.commandline.RelativeFileSourceNamePrinter;
import com.github.sommeri.less4j.utils.ProblemsPrinter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class CommandLinePrint {
    private PrintStream standardOut;
    private PrintStream standardErr;

    public CommandLinePrint() {
        this(System.out, System.err);
    }

    public CommandLinePrint(PrintStream standardOut, PrintStream standardErr) {
        this.standardOut = standardOut;
        this.standardErr = standardErr;
    }

    public void printToSysout(LessCompiler.CompilationResult content, String inputfileName, File rootInputFile) {
        if (content == null || content.getCss() == null) {
            this.reportCouldNotCompileTheFile(inputfileName);
            return;
        }
        this.standardOut.print(content.getCss());
        this.printWarnings(inputfileName, rootInputFile, content);
    }

    void reportCouldNotCompileTheFile(String inputfile) {
        this.reportError("Could not compile the file " + inputfile);
    }

    public void printToFiles(LessCompiler.CompilationResult content, String lessFileName, File rootLessFile, String cssFilename, String mapFilename) {
        if (content == null || content.getCss() == null) {
            this.reportCouldNotCompileTheFile(lessFileName);
            return;
        }
        this.outputFile(cssFilename, content.getCss());
        if (mapFilename != null && content.getSourceMap() != null) {
            this.outputFile(mapFilename, content.getSourceMap());
        }
        this.printWarnings(lessFileName, rootLessFile, content);
    }

    public void printWarnings(String inputfileName, File rootInputFile, LessCompiler.CompilationResult content) {
        RelativeFileSourceNamePrinter sourceNamePrinter = new RelativeFileSourceNamePrinter(rootInputFile);
        ProblemsPrinter problemsPrinter = new ProblemsPrinter(sourceNamePrinter);
        if (!content.getWarnings().isEmpty()) {
            this.standardErr.println("Warnings produced by compilation of " + inputfileName);
        }
        String warnings = problemsPrinter.printWarnings(content.getWarnings());
        this.standardErr.print(warnings);
    }

    private void outputFile(String filename, String content) {
        File file = new File(filename);
        this.outputFile(filename, file, content);
    }

    private void outputFile(String reportFilename, File file, String content) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            this.reportError("Could not create the file " + reportFilename);
            this.reportError(e);
            return;
        }
        if (!file.canWrite()) {
            this.reportError("Can not write into file " + reportFilename);
            return;
        }
        try {
            FileWriter output = new FileWriter(file);
            IOUtils.write((String)content, (Writer)output);
            output.close();
        }
        catch (IOException e) {
            this.reportError("Can not write into file " + reportFilename);
            this.reportError(e);
            return;
        }
    }

    protected void reportError(String message) {
        this.standardErr.println(message);
    }

    public void reportErrorsAndWarnings(Less4jException ex, String inputfileName, File rootInputFile) {
        this.printWarnings(inputfileName, rootInputFile, ex.getPartialResult());
        this.reportErrors(ex, inputfileName, rootInputFile);
    }

    public void reportErrors(Less4jException ex, String inputfileName, File rootInputFile) {
        RelativeFileSourceNamePrinter sourceNamePrinter = new RelativeFileSourceNamePrinter(rootInputFile);
        ProblemsPrinter problemsPrinter = new ProblemsPrinter(sourceNamePrinter);
        if (!ex.getErrors().isEmpty()) {
            this.standardErr.println("Errors produced by compilation of " + inputfileName);
        }
        String errors = problemsPrinter.printErrors(ex.getErrors());
        this.standardErr.print(errors);
    }

    protected void reportError(Throwable e) {
        e.printStackTrace(this.standardErr);
    }

    public boolean ensureDirectory(String outputDirectory) {
        if (outputDirectory == null || outputDirectory.isEmpty()) {
            return true;
        }
        File directory = new File(outputDirectory);
        if (directory.exists() && !directory.isDirectory()) {
            this.reportError(directory + " is not a directory.");
            return false;
        }
        if (!directory.exists() && !directory.mkdirs()) {
            this.reportError("Could not create the directory " + directory + ".");
            return false;
        }
        return true;
    }
}

