/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.content;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.content.MSBatchRequestStep;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Headers;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Request;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.RequestBody;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okio.Buffer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MSBatchRequestContent {
    private Map<String, MSBatchRequestStep> batchRequestStepsHashMap;
    public static final int MAX_NUMBER_OF_REQUESTS = 20;

    public MSBatchRequestContent(List<MSBatchRequestStep> batchRequestStepsArray) {
        if (batchRequestStepsArray.size() > 20) {
            throw new IllegalArgumentException("Number of batch request steps cannot exceed 20");
        }
        this.batchRequestStepsHashMap = new HashMap<String, MSBatchRequestStep>();
        for (MSBatchRequestStep requestStep : batchRequestStepsArray) {
            this.addBatchRequestStep(requestStep);
        }
    }

    public MSBatchRequestContent() {
        this.batchRequestStepsHashMap = new HashMap<String, MSBatchRequestStep>();
    }

    public boolean addBatchRequestStep(MSBatchRequestStep batchRequestStep) {
        if (this.batchRequestStepsHashMap.containsKey(batchRequestStep.getRequestId())) {
            return false;
        }
        this.batchRequestStepsHashMap.put(batchRequestStep.getRequestId(), batchRequestStep);
        return true;
    }

    public boolean removeBatchRequestStepWithId(String requestId) {
        boolean removed = false;
        if (this.batchRequestStepsHashMap.containsKey(requestId)) {
            this.batchRequestStepsHashMap.remove(requestId);
            removed = true;
            for (Map.Entry<String, MSBatchRequestStep> steps : this.batchRequestStepsHashMap.entrySet()) {
                if (steps.getValue() == null || steps.getValue().getArrayOfDependsOnIds() == null) continue;
                while (steps.getValue().getArrayOfDependsOnIds().remove(requestId)) {
                }
            }
        }
        return removed;
    }

    public String getBatchRequestContent() {
        JSONObject batchRequestContentMap = new JSONObject();
        JSONArray batchContentArray = new JSONArray();
        for (Map.Entry<String, MSBatchRequestStep> requestStep : this.batchRequestStepsHashMap.entrySet()) {
            batchContentArray.add((Object)this.getBatchRequestObjectFromRequestStep(requestStep.getValue()));
        }
        batchRequestContentMap.put((Object)"requests", (Object)batchContentArray);
        String content = batchRequestContentMap.toString();
        return content;
    }

    private JSONObject getBatchRequestObjectFromRequestStep(MSBatchRequestStep batchRequestStep) {
        RequestBody body;
        List<String> arrayOfDependsOnIds;
        JSONObject contentmap = new JSONObject();
        contentmap.put((Object)"id", (Object)batchRequestStep.getRequestId());
        String url = batchRequestStep.getRequest().url().toString();
        url = url.replaceAll("https://graph.microsoft.com/v1.0/", "");
        url = url.replaceAll("http://graph.microsoft.com/v1.0/", "");
        url = url.replaceAll("https://graph.microsoft.com/beta/", "");
        url = url.replaceAll("http://graph.microsoft.com/beta/", "");
        contentmap.put((Object)"url", (Object)url);
        contentmap.put((Object)"method", (Object)batchRequestStep.getRequest().method().toString());
        Headers headers = batchRequestStep.getRequest().headers();
        if (headers != null && headers.size() != 0) {
            JSONObject headerMap = new JSONObject();
            for (Map.Entry<String, List<String>> entry : headers.toMultimap().entrySet()) {
                headerMap.put((Object)entry.getKey(), (Object)this.getHeaderValuesAsString(entry.getValue()));
            }
            contentmap.put((Object)"headers", (Object)headerMap);
        }
        if ((arrayOfDependsOnIds = batchRequestStep.getArrayOfDependsOnIds()) != null) {
            JSONArray array = new JSONArray();
            for (String dependsOnId : arrayOfDependsOnIds) {
                array.add((Object)dependsOnId);
            }
            contentmap.put((Object)"dependsOn", (Object)array);
        }
        if ((body = batchRequestStep.getRequest().body()) != null) {
            try {
                contentmap.put((Object)"body", (Object)this.requestBodyToJSONObject(batchRequestStep.getRequest()));
            }
            catch (IOException | ParseException throwable) {
                throwable.printStackTrace();
            }
        }
        return contentmap;
    }

    private String getHeaderValuesAsString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            builder.append(";");
            builder.append(list.get(i));
        }
        return builder.toString();
    }

    private JSONObject requestBodyToJSONObject(Request request) throws IOException, ParseException {
        if (request == null || request.body() == null) {
            return null;
        }
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        copy.body().writeTo(buffer);
        String requestBody = buffer.readUtf8();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(requestBody);
        return jsonObject;
    }
}

