/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorAmountFunction;
import com.github.sommeri.less4j.core.compiler.expressions.HSLAValue;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;

class Fade
extends AbstractColorAmountFunction {
    public Fade() {
        super(false);
    }

    @Override
    protected Expression evaluate(ColorExpression color, NumberExpression amount, boolean isAbsolute, HiddenTokenAwareTree token) {
        HSLAValue hsla = Fade.toHSLA(color);
        this.apply(amount, hsla);
        return Fade.hsla(hsla, token);
    }

    protected void apply(NumberExpression amount, HSLAValue hsla) {
        hsla.a = amount.getValueAsDouble() / 100.0;
        hsla.a = Fade.clamp(hsla.a);
    }

    @Override
    protected String getName() {
        return "fade";
    }
}

