/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.ObjectTypesEnum;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.util.StringUtil;

public abstract class AbstractObjectNamingRule
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public final boolean internalEvaluate(ChangeSet object, DynamicRule dynamicRule) {
        Object object2 = dynamicRule.getParameter(DynamicRuleParameterEnum.OPERATOR);
        Object object3 = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        Object object4 = dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE);
        DynamicRuleParameter object52 = dynamicRule.getParameter(DynamicRuleParameterEnum.OBJECT_TYPES);
        object2 = OperatorEnum.valueOf((String)((DynamicRuleParameter)object2).getValue());
        object3 = (String)((DynamicRuleParameter)object3).getValue();
        Boolean bl2 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (object2 != OperatorEnum.REGEXP) {
            bl2 = (Boolean)((DynamicRuleParameter)object4).getValue();
        } else if (object4 != null) {
            this.setResultUnsuccessful("Rule is using a " + (Object)((Object)OperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.", dynamicRule);
        }
        object4 = StringEnumListGetter.split((String)object52.getValue(), ObjectTypesEnum.class);
        for (Change change : ((ChangeSet)((Object)object)).getChanges()) {
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                Object jSQLParserException;
                int n2;
                Object object5;
                ObjectTypesEnum objectTypesEnum = (ObjectTypesEnum)((Object)iterator.next());
                ArrayList arrayList = new ArrayList();
                if (change instanceof AbstractSQLChange) {
                    try {
                        object5 = StringUtil.splitSQL(StringUtil.stripComments(((AbstractSQLChange)change).getSql()), ((AbstractSQLChange)change).getEndDelimiter());
                        n2 = ((String[])object5).length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Object object6 = JSqlParserCache.parseSql(object5[i2], true);
                            if ((object6 = objectTypesEnum.sqlCallback.apply((Statement)object6)) == null || !this.notAllEmpty((List<String>)object6)) continue;
                            arrayList.addAll(object6.stream().map(AbstractObjectNamingRule::cleanseQuotes).collect(Collectors.toList()));
                        }
                    }
                    catch (JSQLParserException jSQLParserException2) {
                        Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to parse SQL", jSQLParserException2);
                        this.addFailureRuleIteration("Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration$FailureReason.SQL_PARSING, dynamicRule);
                    }
                } else if (change instanceof AbstractChange && (jSQLParserException = objectTypesEnum.abstractChangeCallback.apply((AbstractChange)change)) != null && this.notAllEmpty((List<String>)jSQLParserException)) {
                    arrayList.addAll(jSQLParserException);
                }
                jSQLParserException = arrayList.iterator();
                while (jSQLParserException.hasNext()) {
                    object5 = (String)jSQLParserException.next();
                    n2 = ((OperatorEnum)((Object)object2)).matches((String)object3, (String)object5, bl2) ? 1 : 0;
                    if (!this.operatorMatchCallback(n2 != 0)) continue;
                    AbstractObjectNamingRule abstractObjectNamingRule = this;
                    abstractObjectNamingRule.addFailureRuleIteration(abstractObjectNamingRule.getFailureMessage(objectTypesEnum, (OperatorEnum)((Object)object2), (String)object3), dynamicRule);
                }
            }
        }
        return this.returnAtEndOfRule(dynamicRule);
    }

    private boolean notAllEmpty(List<String> list) {
        return list.stream().noneMatch(String::isEmpty);
    }

    public abstract boolean operatorMatchCallback(boolean var1);

    public abstract String getFailureMessage(ObjectTypesEnum var1, OperatorEnum var2, String var3);

    @Override
    public final List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.SEARCH_STRING, (string, list) -> {
            if (list.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst().get().getValue() == OperatorEnum.REGEXP) {
                return new RegexGetter().validate((String)string);
            }
            if (StringUtil.isEmpty(string)) {
                throw new IllegalArgumentException("The search string is empty or contains invalid characters.");
            }
            return Boolean.TRUE;
        }, null), new RuleParameter(DynamicRuleParameterEnum.OBJECT_TYPES), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE, null, list -> list.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst().get().getValue() != OperatorEnum.REGEXP));
    }

    private static String cleanseQuotes(String string) {
        Iterator<String> iterator = Arrays.asList("\"", "[", "`");
        List<String> list = Arrays.asList("\"", "]", "`");
        String string2 = string;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string.startsWith(string3)) continue;
            string2 = string2.substring(string3.length());
            break;
        }
        for (String string3 : list) {
            if (!string.endsWith(string3)) continue;
            string2 = string2.substring(0, string2.length() - string3.length());
            break;
        }
        return string2;
    }
}

