/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.RemoteAssistancePartner;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IRemoteAssistancePartnerCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IRemoteAssistancePartnerCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RemoteAssistancePartnerCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RemoteAssistancePartnerCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RemoteAssistancePartnerCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.RemoteAssistancePartnerRequestBuilder;

public class RemoteAssistancePartnerCollectionRequest
extends BaseCollectionRequest<RemoteAssistancePartnerCollectionResponse, IRemoteAssistancePartnerCollectionPage>
implements IRemoteAssistancePartnerCollectionRequest {
    public RemoteAssistancePartnerCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RemoteAssistancePartnerCollectionResponse.class, IRemoteAssistancePartnerCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IRemoteAssistancePartnerCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(RemoteAssistancePartnerCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IRemoteAssistancePartnerCollectionPage get() throws ClientException {
        RemoteAssistancePartnerCollectionResponse response = (RemoteAssistancePartnerCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(RemoteAssistancePartner newRemoteAssistancePartner, ICallback<RemoteAssistancePartner> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new RemoteAssistancePartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRemoteAssistancePartner, callback);
    }

    @Override
    public RemoteAssistancePartner post(RemoteAssistancePartner newRemoteAssistancePartner) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new RemoteAssistancePartnerRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newRemoteAssistancePartner);
    }

    @Override
    public IRemoteAssistancePartnerCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IRemoteAssistancePartnerCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRemoteAssistancePartnerCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IRemoteAssistancePartnerCollectionPage buildFromResponse(RemoteAssistancePartnerCollectionResponse response) {
        RemoteAssistancePartnerCollectionRequestBuilder builder = response.nextLink != null ? new RemoteAssistancePartnerCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        RemoteAssistancePartnerCollectionPage page = new RemoteAssistancePartnerCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

