/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cms.clouddrives.CloudDriveException;
import org.exoplatform.services.cms.clouddrives.CloudFile;
import org.exoplatform.services.cms.clouddrives.CloudFileAPI;
import org.exoplatform.services.cms.clouddrives.CloudFileSynchronizer;
import org.exoplatform.services.cms.clouddrives.SkipSyncException;
import org.exoplatform.services.cms.clouddrives.SyncNotSupportedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public final class LostRemovalSynchronizer
implements CloudFileSynchronizer {
    protected static final Log LOG = ExoLogger.getLogger(LostRemovalSynchronizer.class);

    @Override
    public String[] getSupportedNodetypes() {
        return new String[0];
    }

    @Override
    public boolean accept(Node file) throws RepositoryException, SkipSyncException {
        return false;
    }

    @Override
    public boolean remove(String filePath, String fileId, boolean isFolder, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        if (isFolder) {
            api.removeFolder(fileId);
        } else {
            api.removeFile(fileId);
        }
        return true;
    }

    @Override
    public boolean trash(String filePath, String fileId, boolean isFolder, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        if (isFolder) {
            return api.trashFolder(fileId);
        }
        return api.trashFile(fileId);
    }

    @Override
    public CloudFile create(Node file, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public CloudFile untrash(Node file, CloudFileAPI api) throws RepositoryException, CloudDriveException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public CloudFile update(Node file, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public CloudFile updateContent(Node file, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        throw new SyncNotSupportedException("Not supported");
    }

    @Override
    public CloudFile copy(Node srcFile, Node destFile, CloudFileAPI api) throws CloudDriveException, RepositoryException {
        throw new SyncNotSupportedException("Not supported");
    }
}

