/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.documents;

import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletRequest;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.impl.EditorProvidersHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class DocumentEditorsLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    public static final String USERID_ATTRIBUTE = "DocumentEditorsContext.userId";
    public static final String DOCUMENT_WORKSPACE_ATTRIBUTE = "DocumentEditorsContext.document.workspace";
    public static final String DOCUMENT_PATH_ATTRIBUTE = "DocumentEditorsContext.document.path";
    protected static final Log LOG = ExoLogger.getLogger(DocumentEditorsLifecycle.class);
    protected static final String MIX_REFERENCEABLE = "mix:referenceable";
    protected DocumentService documentService;

    public void onInit(Application app) throws Exception {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) {
    }

    public void onDestroy(Application app) throws Exception {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        RequestContext parentContext = context.getParentAppRequestContext();
        UIJCRExplorer explorer = (UIJCRExplorer)context.getUIApplication().findFirstComponentOfType(UIJCRExplorer.class);
        if (explorer != null && parentContext != null) {
            try {
                String userName = context.getRemoteUser();
                Node node = explorer.getCurrentNode();
                String nodeWs = node.getSession().getWorkspace().getName();
                String nodePath = node.getPath();
                if (node.isNodeType(MIX_REFERENCEABLE) && this.isNotSameUserDocument(userName, nodeWs, nodePath, parentContext)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Init documents explorer for {}, node: {}:{}, context: {}", new Object[]{userName, nodeWs, nodePath, parentContext});
                    }
                    parentContext.setAttribute(USERID_ATTRIBUTE, (Object)userName);
                    parentContext.setAttribute(DOCUMENT_WORKSPACE_ATTRIBUTE, (Object)nodeWs);
                    parentContext.setAttribute(DOCUMENT_PATH_ATTRIBUTE, (Object)nodePath);
                    this.initExplorer(context, node.getUUID(), node.getSession().getWorkspace().getName());
                }
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Couldn't initialize document editors JS module", (Throwable)e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Explorer or portal context not found, explorer: {}, context: {}", new Object[]{explorer, parentContext});
        }
    }

    protected ServletRequest getServletRequest(WebuiRequestContext context) {
        try {
            return (ServletRequest)context.getRequest();
        }
        catch (ClassCastException e) {
            RequestContext parentContext = context.getParentAppRequestContext();
            if (parentContext != null && PortalRequestContext.class.isAssignableFrom(parentContext.getClass())) {
                return ((PortalRequestContext)PortalRequestContext.class.cast(parentContext)).getRequest();
            }
            return null;
        }
    }

    protected void initExplorer(WebuiRequestContext context, String fileId, String workspace) throws RepositoryException {
        Identity identity = ConversationState.getCurrent().getIdentity();
        List providers = this.getDocumentService().getDocumentEditorProviders();
        List providersInfo = EditorProvidersHelper.getInstance().initExplorer(providers, identity, fileId, workspace, context);
        try {
            String providersInfoJson = new JsonGeneratorImpl().createJsonArray((Collection)providersInfo).toString();
            RequireJS require = context.getJavascriptManager().require("SHARED/editorbuttons", "editorbuttons");
            require.addScripts("editorbuttons.initExplorer('" + fileId + "', '" + workspace + "', " + providersInfoJson + ");");
        }
        catch (JsonException e) {
            LOG.warn("Cannot generate JSON for initializing exprorer in editors module. {}", new Object[]{e.getMessage()});
        }
    }

    private boolean isNotSameUserDocument(String userName, String nodeWs, String nodePath, RequestContext parentContext) {
        return !userName.equals(parentContext.getAttribute(USERID_ATTRIBUTE)) || !nodeWs.equals(parentContext.getAttribute(DOCUMENT_WORKSPACE_ATTRIBUTE)) || !nodePath.equals(parentContext.getAttribute(DOCUMENT_PATH_ATTRIBUTE));
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)WebuiRequestContext.getCurrentInstance().getApplication().getApplicationServiceContainer().getComponentInstanceOfType(DocumentService.class);
        }
        return this.documentService;
    }
}

