/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Stream;

public class PDFThumbnailPlugin
implements ComponentPlugin,
ThumbnailPlugin {
    private ThumbnailType config;
    private String description;
    private String name;
    private static final Log LOG = ExoLogger.getExoLogger((String)PDFThumbnailPlugin.class.getName());

    public PDFThumbnailPlugin(InitParams initParams) throws Exception {
        this.config = (ThumbnailType)initParams.getObjectParamValues(ThumbnailType.class).get(0);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public BufferedImage getBufferedImage(Node contentNode, String nodePath) throws Exception {
        Document document;
        block8: {
            document = new Document();
            Logger.getLogger(Stream.class.toString()).setLevel(Level.OFF);
            try {
                InputStream input = contentNode.getProperty("jcr:data").getStream();
                document.setInputStream(input, nodePath);
            }
            catch (PDFException ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Error parsing PDF document " + ex));
                }
            }
            catch (PDFSecurityException ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Error encryption not supported " + ex));
                }
            }
            catch (FileNotFoundException ex) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Error file not found " + ex));
                }
            }
            catch (IOException ex) {
                if (!LOG.isWarnEnabled()) break block8;
                LOG.warn((Object)("Error handling PDF document " + contentNode.getPath()));
            }
        }
        BufferedImage image = (BufferedImage)document.getPageImage(0, 1, 2, 0.0f, 1.0f);
        document.dispose();
        return image;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.config.getMimeTypes();
    }
}

