/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.geoapi.evolution.UnsupportedCodeList;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultTelephone;
import org.apache.sis.util.resources.Messages;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Contact_Type", propOrder={"phone", "phoneList", "address", "addressList", "onlineResource", "onlineResourceList", "hoursOfService", "contactInstructions", "contactType"})
@XmlRootElement(name="CI_Contact")
public class DefaultContact
extends ISOMetadata
implements Contact {
    private static final long serialVersionUID = -969735574940462381L;
    private Collection<Telephone> phones;
    private Collection<Address> addresses;
    private Collection<OnlineResource> onlineResources;
    private InternationalString hoursOfService;
    private InternationalString contactInstructions;
    private InternationalString contactType;

    public DefaultContact() {
    }

    public DefaultContact(OnlineResource onlineResource) {
        this.onlineResources = this.singleton(onlineResource, OnlineResource.class);
    }

    public DefaultContact(Contact contact) {
        super(contact);
        if (contact != null) {
            this.hoursOfService = contact.getHoursOfService();
            this.contactInstructions = contact.getContactInstructions();
            if (contact instanceof DefaultContact) {
                DefaultContact defaultContact = (DefaultContact)contact;
                this.phones = this.copyCollection(defaultContact.getPhones(), Telephone.class);
                this.addresses = this.copyCollection(defaultContact.getAddresses(), Address.class);
                this.onlineResources = this.copyCollection(defaultContact.getOnlineResources(), OnlineResource.class);
                this.contactType = defaultContact.getContactType();
            } else {
                this.phones = this.singleton(contact.getPhone(), Telephone.class);
                this.addresses = this.singleton(contact.getAddress(), Address.class);
                this.onlineResources = this.singleton(contact.getOnlineResource(), OnlineResource.class);
            }
        }
    }

    public static DefaultContact castOrCopy(Contact contact) {
        if (contact == null || contact instanceof DefaultContact) {
            return (DefaultContact)contact;
        }
        return new DefaultContact(contact);
    }

    @UML(identifier="phone", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Telephone> getPhones() {
        this.phones = this.nonNullCollection(this.phones, Telephone.class);
        return this.phones;
    }

    public void setPhones(Collection<? extends Telephone> collection) {
        this.phones = this.writeCollection(collection, this.phones, Telephone.class);
        if (this.phones != null) {
            boolean bl = false;
            Telephone[] telephoneArray = this.phones.toArray(new Telephone[collection.size()]);
            for (int i = 0; i < telephoneArray.length; ++i) {
                Telephone telephone = telephoneArray[i];
                if (!(telephone instanceof DefaultTelephone)) continue;
                telephoneArray[i] = ((DefaultTelephone)telephone).setOwner(this.phones);
                bl |= telephoneArray[i] != telephone;
            }
            if (bl) {
                this.phones.clear();
                this.phones.addAll(Arrays.asList(telephoneArray));
            }
        }
    }

    @Deprecated
    @Dependencies(value={"getPhones"})
    @XmlElement(name="phone", namespace="http://www.isotc211.org/2005/gmd")
    public Telephone getPhone() {
        Collection<Telephone> collection;
        Telephone telephone = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (collection = this.getPhones()) != null) {
            CodeList<?> codeList = null;
            for (Telephone telephone2 : collection) {
                String string;
                if (!(telephone2 instanceof DefaultTelephone)) continue;
                CodeList<?> codeList2 = ((DefaultTelephone)telephone2).numberType;
                if (codeList2 != null && ("VOICE".equals(string = codeList2.name()) || "FACSIMILE".equals(string))) {
                    if (telephone != null) continue;
                    telephone = telephone2;
                    continue;
                }
                if (codeList != null) continue;
                codeList = codeList2;
            }
            if (codeList != null) {
                Context.warningOccured(Context.current(), DefaultContact.class, "getPhone", Messages.class, (short)21, codeList);
            }
        }
        return telephone;
    }

    @Deprecated
    public void setPhone(Telephone telephone) {
        Collection<Telephone> collection = null;
        if (telephone != null) {
            if (telephone instanceof DefaultTelephone) {
                collection = ((DefaultTelephone)telephone).getOwner();
            } else {
                collection = new ArrayList<Telephone>(4);
                for (String string : telephone.getVoices()) {
                    collection.add(new DefaultTelephone(string, UnsupportedCodeList.VOICE));
                }
                for (String string : telephone.getFacsimiles()) {
                    collection.add(new DefaultTelephone(string, UnsupportedCodeList.FACSIMILE));
                }
            }
        }
        this.setPhones(collection);
    }

    @UML(identifier="address", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Address> getAddresses() {
        this.addresses = this.nonNullCollection(this.addresses, Address.class);
        return this.addresses;
    }

    public void setAddresses(Collection<? extends Address> collection) {
        this.addresses = this.writeCollection(collection, this.addresses, Address.class);
    }

    @Deprecated
    @Dependencies(value={"getAddresses"})
    @XmlElement(name="address", namespace="http://www.isotc211.org/2005/gmd")
    public Address getAddress() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return LegacyPropertyAdapter.getSingleton(this.getAddresses(), Address.class, null, DefaultContact.class, "getAddress");
        }
        return null;
    }

    @Deprecated
    public void setAddress(Address address) {
        this.setAddresses(CollectionsExt.singletonOrEmpty((Object)address));
    }

    @UML(identifier="onlineResource", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getOnlineResources() {
        this.onlineResources = this.nonNullCollection(this.onlineResources, OnlineResource.class);
        return this.onlineResources;
    }

    public void setOnlineResources(Collection<? extends OnlineResource> collection) {
        this.onlineResources = this.writeCollection(collection, this.onlineResources, OnlineResource.class);
    }

    @Deprecated
    @Dependencies(value={"getOnlineResources"})
    @XmlElement(name="onlineResource", namespace="http://www.isotc211.org/2005/gmd")
    public OnlineResource getOnlineResource() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return LegacyPropertyAdapter.getSingleton(this.getOnlineResources(), OnlineResource.class, null, DefaultContact.class, "getOnlineResource");
        }
        return null;
    }

    @Deprecated
    public void setOnlineResource(OnlineResource onlineResource) {
        this.setOnlineResources(CollectionsExt.singletonOrEmpty((Object)onlineResource));
    }

    @XmlElement(name="hoursOfService")
    public InternationalString getHoursOfService() {
        return this.hoursOfService;
    }

    public void setHoursOfService(InternationalString internationalString) {
        this.checkWritePermission();
        this.hoursOfService = internationalString;
    }

    @XmlElement(name="contactInstructions")
    public InternationalString getContactInstructions() {
        return this.contactInstructions;
    }

    public void setContactInstructions(InternationalString internationalString) {
        this.checkWritePermission(this.contactInstructions);
        this.contactInstructions = internationalString;
    }

    @XmlElement(name="contactType")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    @UML(identifier="contactType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getContactType() {
        return this.contactType;
    }

    public void setContactType(InternationalString internationalString) {
        this.checkWritePermission(this.contactType);
        this.contactType = internationalString;
    }

    @XmlElement(name="phone")
    private Collection<Telephone> getPhoneList() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getPhones() : null;
    }

    @XmlElement(name="address")
    private Collection<Address> getAddressList() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAddresses() : null;
    }

    @XmlElement(name="onlineResource")
    private Collection<OnlineResource> getOnlineResourceList() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getOnlineResources() : null;
    }
}

