/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.gamification.github.dao.GitHubAccountDAO;
import org.exoplatform.gamification.github.dao.GitHubHookDAO;
import org.exoplatform.gamification.github.entity.GitHubHookEntity;
import org.exoplatform.gamification.github.exception.GithubHookException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class GithubHooksManagement {
    private static final String ERRORS_GITHUB_NODE = "errors";
    private static final Log LOG = ExoLogger.getLogger(GithubHooksManagement.class);
    private static final String GITHUB_API_URL = "https://api.github.com/repos";
    private static final String MESSAGE_GITHUB_NODE = "message";
    private static final String[] GITHUB_EVENTS = new String[]{"push", "pull_request", "pull_request_review", "pull_request_review_comment", "pull_request_review_comment"};
    private String token = "";
    private String secret = "";
    private String environment = "";
    private String webhookUrl = "portal/rest/gamification/connectors/github/webhooks";
    private ListenerService listenerService;
    private GitHubAccountDAO gitHubAccountDAO;
    private GitHubHookDAO gitHubHookDAO;

    public GithubHooksManagement(ListenerService listenerService, GitHubAccountDAO gitHubAccountDAO, GitHubHookDAO gitHubHookDAO) {
        this.listenerService = listenerService;
        this.gitHubAccountDAO = gitHubAccountDAO;
        this.gitHubHookDAO = gitHubHookDAO;
        this.secret = System.getProperty("gamification.connectors.github.hook.secret");
        this.token = System.getProperty("gamification.connectors.github.hook.token");
        this.environment = System.getProperty("gamification.connectors.github.exo.environment");
        if (System.getProperty("gamification.connectors.github.hook.url") != null) {
            this.webhookUrl = System.getProperty("gamification.connectors.github.hook.url");
        }
    }

    public Long addHook(String webhook, String org, String repo, boolean active) throws IOException, GithubHookException {
        List<GitHubHookEntity> webhooks = this.getHooksByOrgRepoAndEnvironment(org, repo, this.environment);
        if (!webhooks.isEmpty()) {
            throw new GithubHookException("WebHook already exists");
        }
        JSONObject config = new JSONObject();
        JSONObject hook = new JSONObject();
        String url = "https://api.github.com/repos/" + org + "/" + repo + "/hooks";
        try {
            config.put("url", (Object)webhook);
            config.put("content_type", (Object)"json");
            config.put("insecure_ssl", (Object)"0");
            config.put("secret", (Object)this.secret);
            hook.put("name", (Object)"web");
            hook.put("active", active);
            hook.put("config", (Object)config);
            hook.put("events", (Object)GITHUB_EVENTS);
        }
        catch (JSONException e) {
            LOG.error((Object)e);
        }
        URL obj = new URL(url);
        HttpURLConnection postConnection = (HttpURLConnection)obj.openConnection();
        postConnection.setRequestMethod("POST");
        this.setAuthorizationHeader(postConnection);
        postConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        postConnection.setDoOutput(true);
        try (OutputStream os = postConnection.getOutputStream();){
            os.write(hook.toString().getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        int responseCode = postConnection.getResponseCode();
        if (responseCode == 201) {
            Long l;
            block30: {
                InputStream in = postConnection.getInputStream();
                try {
                    String response = IOUtil.getStreamContentAsString((InputStream)in);
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode infoNode = objectMapper.readTree(response);
                    l = infoNode.get("id").longValue();
                    if (in == null) break block30;
                }
                catch (Throwable response) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable objectMapper) {
                                response.addSuppressed(objectMapper);
                            }
                        }
                        throw response;
                    }
                    catch (IOException e) {
                        LOG.error((Object)e);
                    }
                }
                in.close();
            }
            return l;
        } else {
            try {
                InputStream in = postConnection.getInputStream();
                try {
                    String response = IOUtil.getStreamContentAsString((InputStream)in);
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode infoNode = objectMapper.readTree(response);
                    Object errMessage = infoNode.get(MESSAGE_GITHUB_NODE).textValue();
                    if (infoNode.get(ERRORS_GITHUB_NODE) != null) {
                        errMessage = (String)errMessage + ": " + ((JsonNode)infoNode.get(ERRORS_GITHUB_NODE).elements().next()).get(MESSAGE_GITHUB_NODE).textValue();
                    }
                    throw new GithubHookException((String)errMessage);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        return null;
    }

    public void updateHook(GitHubHookEntity webhook, String fullPath) throws IOException, GithubHookException {
        JSONObject config = new JSONObject();
        JSONObject hook = new JSONObject();
        String url = "https://api.github.com/repos/" + webhook.getOrganization() + "/" + webhook.getRepo() + "/hooks/" + webhook.getGithubId();
        try {
            config.put("url", (Object)fullPath);
            config.put("content_type", (Object)"json");
            config.put("insecure_ssl", (Object)"0");
            config.put("secret", (Object)this.secret);
            hook.put("name", (Object)"web");
            hook.put("active", (Object)webhook.getEnabled());
            hook.put("config", (Object)config);
            hook.put("events", (Object)GITHUB_EVENTS);
        }
        catch (JSONException e) {
            LOG.error((Object)e);
        }
        URL obj = new URL(url);
        HttpURLConnection patchConnection = (HttpURLConnection)obj.openConnection();
        patchConnection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
        patchConnection.setRequestMethod("POST");
        this.setAuthorizationHeader(patchConnection);
        patchConnection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        patchConnection.setDoOutput(true);
        try (OutputStream os = patchConnection.getOutputStream();){
            os.write(hook.toString().getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        int responseCode = patchConnection.getResponseCode();
        if (responseCode == 200) {
            this.updateHookEntity(webhook);
        } else {
            try {
                InputStream in = patchConnection.getInputStream();
                try {
                    String response = IOUtil.getStreamContentAsString((InputStream)in);
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode infoNode = objectMapper.readTree(response);
                    Object errMessage = infoNode.get(MESSAGE_GITHUB_NODE).textValue();
                    if (infoNode.get(ERRORS_GITHUB_NODE) != null) {
                        errMessage = (String)errMessage + ": " + ((JsonNode)infoNode.get(ERRORS_GITHUB_NODE).elements().next()).get(MESSAGE_GITHUB_NODE).textValue();
                    }
                    throw new GithubHookException((String)errMessage);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public void deleteHook(GitHubHookEntity webhook) throws IOException, GithubHookException {
        String url = "https://api.github.com/repos/" + webhook.getOrganization() + "/" + webhook.getRepo() + "/hooks/" + webhook.getGithubId();
        URL obj = new URL(url);
        HttpURLConnection deleteConnection = (HttpURLConnection)obj.openConnection();
        deleteConnection.setRequestMethod("DELETE");
        this.setAuthorizationHeader(deleteConnection);
        int responseCode = deleteConnection.getResponseCode();
        if (responseCode == 204) {
            this.deleteHookEntity(webhook);
        } else {
            try {
                InputStream in = deleteConnection.getInputStream();
                try {
                    String response = IOUtil.getStreamContentAsString((InputStream)in);
                    ObjectMapper objectMapper = new ObjectMapper();
                    JsonNode infoNode = objectMapper.readTree(response);
                    Object errMessage = infoNode.get(MESSAGE_GITHUB_NODE).textValue();
                    if (infoNode.get(ERRORS_GITHUB_NODE) != null) {
                        errMessage = (String)errMessage + ": " + ((JsonNode)infoNode.get(ERRORS_GITHUB_NODE).elements().next()).get(MESSAGE_GITHUB_NODE).textValue();
                    }
                    throw new GithubHookException((String)errMessage);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public List<GitHubHookEntity> getAllHooks() {
        return this.getHooksByExoEnvironment(this.environment);
    }

    public List<GitHubHookEntity> getHooksByExoEnvironment(String environment) {
        return this.gitHubHookDAO.getHooksByExoEnvironment(environment);
    }

    public List<GitHubHookEntity> getHooksByOrgRepoAndEnvironment(String org, String repo, String env) {
        return this.gitHubHookDAO.getHooksByOrgRepoAndEnvironment(org, repo, env);
    }

    public GitHubHookEntity createHook(Long id, GitHubHookEntity hook, boolean enabled) {
        hook.setGithubId(id);
        hook.setEvents("push, pull_request,pull_request_review,pull_request_review_comment,pull_request_review_comment");
        hook.setEnabled(enabled);
        hook.setExoEnvironment(this.environment);
        hook.setCreatedDate(new Date());
        hook.setUpdatedDate(new Date());
        return (GitHubHookEntity)this.gitHubHookDAO.create(hook);
    }

    public GitHubHookEntity updateHookEntity(GitHubHookEntity hook) {
        hook.setUpdatedDate(new Date());
        return (GitHubHookEntity)this.gitHubHookDAO.update(hook);
    }

    public void deleteHookEntity(GitHubHookEntity hook) {
        this.gitHubHookDAO.delete(hook);
    }

    public GitHubHookEntity getHookEntityById(long id) {
        return (GitHubHookEntity)this.gitHubHookDAO.find(Long.valueOf(id));
    }

    public void createGamificationHistory(String ruleTitle, String senderId, String receiverId, String object) {
        try {
            HashMap<String, String> gam = new HashMap<String, String>();
            gam.put("ruleTitle", ruleTitle);
            gam.put("senderId", senderId);
            gam.put("receiverId", receiverId);
            gam.put("object", object);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)"");
            LOG.info("Github action {} gamified for user {} {} {}", new Object[]{ruleTitle, senderId, ruleTitle.equals("pullRequestValidated") ? "from" : "to", receiverId});
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast gamification event", (Throwable)e);
        }
    }

    public void broadcastGithubEvent(String ruleTitle, String senderId, String receiverId, String object) {
        try {
            HashMap<String, String> gam = new HashMap<String, String>();
            gam.put("ruleTitle", ruleTitle);
            gam.put("senderId", senderId);
            gam.put("receiverId", receiverId);
            gam.put("object", object);
            this.listenerService.broadcast("exo.github.event", gam, (Object)"");
            LOG.info("Github action {} brodcasted for user {}", new Object[]{ruleTitle, senderId});
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot broadcast github event", (Throwable)e);
        }
    }

    public String getUserByGithubId(String id) {
        if (id == null) {
            return null;
        }
        try {
            return this.gitHubAccountDAO.getAccountByGithubId(id).getUserName();
        }
        catch (NullPointerException e) {
            LOG.error("Cannot get user with GithubId {}", new Object[]{id});
            return null;
        }
        catch (Exception e) {
            LOG.error("Cannot get user with GithubId {}", new Object[]{id, e});
            return null;
        }
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getExoEnvironment() {
        return this.environment;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    private void setAuthorizationHeader(HttpURLConnection conection) {
        conection.setRequestProperty("Authorization", "token " + this.token);
    }
}

