/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheKey;

class CacheQPath
extends CacheKey {
    private final String parentId;
    private final QPath path;
    private final String key;
    private final ItemType itemType;

    CacheQPath(String parentId, QPath path, ItemType itemType) {
        this.parentId = parentId;
        this.path = path;
        this.itemType = itemType;
        this.key = this.key(this.parentId, this.path.getEntries(), this.itemType);
    }

    CacheQPath(String parentId, QPathEntry name, ItemType itemType) {
        this.parentId = parentId;
        this.path = null;
        this.itemType = itemType;
        this.key = this.key(this.parentId, name, this.itemType);
    }

    protected String key(String parentId, QPathEntry[] pathEntries, ItemType itemType) {
        return this.key(parentId, pathEntries[pathEntries.length - 1], itemType);
    }

    protected String key(String parentId, QPathEntry name, ItemType itemType) {
        StringBuilder sk = new StringBuilder();
        sk.append(parentId != null ? parentId : Constants.ROOT_PARENT_UUID);
        sk.append(name.getAsString(true));
        sk.append(itemType.toString());
        return sk.toString();
    }

    public boolean equals(Object obj) {
        if (this.key.hashCode() == obj.hashCode() && obj instanceof CacheQPath) {
            return this.key.equals(((CacheQPath)obj).key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.parentId != null ? this.parentId : Constants.ROOT_PARENT_UUID);
        s.append(this.path != null ? this.path.getEntries()[this.path.getEntries().length - 1] : "null");
        s.append(", ");
        s.append(this.key);
        return s.toString();
    }

    QPath getQPath() {
        return this.path;
    }

    @Override
    boolean isDescendantOf(QPath path) {
        return this.path.isDescendantOf(path);
    }
}

