/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MySQLMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MySQLSingleDbJDBCConnection;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class MySQLConnectionFactory
extends GenericCQConnectionFactory {
    public MySQLConnectionFactory(DataSource dbDataSource, JDBCDataContainerConfig containerConfig) {
        super(dbDataSource, containerConfig);
    }

    @Override
    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                return new MySQLMultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return new MySQLSingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

