/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StreamPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableIOSupport;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileDigestOutputStream;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.WriteValue;
import org.exoplatform.services.jcr.impl.util.io.DirectoryHelper;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.IdGenerator;

public class CASableWriteValue
extends WriteValue {
    protected final ValueContentAddressStorage vcas;
    protected final CASableIOSupport cas;
    protected final String propertyId;
    protected final int orderNumb;
    protected File tempFile;
    protected File vcasFile;
    protected String vcasHash;

    public CASableWriteValue(ValueData value, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir, String propertyId, ValueContentAddressStorage vcas, CASableIOSupport cas, ChangedSizeHandler sizeHandler) {
        super(null, value, resources, cleaner, tempDir, sizeHandler);
        this.vcas = vcas;
        this.cas = cas;
        this.propertyId = propertyId;
        this.orderNumb = value.getOrderNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        this.makePerformed();
        File temp = new File(this.tempDir, IdGenerator.generate() + "-" + this.propertyId + this.orderNumb + ".temp");
        try (FileDigestOutputStream out = this.cas.openFile(temp);){
            long contentSize = this.writeOutput(out, this.value);
            this.sizeHandler.accumulateNewSize(contentSize);
        }
        this.vcasHash = out.getDigestHash();
        this.vcasFile = this.cas.getFile(this.vcasHash);
        this.fileLock = new ValueFileOperation.ValueFileLock(this, this.vcasFile);
        this.fileLock.lock();
        this.tempFile = temp;
    }

    @Override
    public void prepare() throws IOException {
        if (this.fileLock != null) {
            try {
                this.vcas.addValue(this.propertyId, this.orderNumb, this.vcasHash);
            }
            catch (RecordAlreadyExistsException e) {
                if (this.tempFile != null && this.tempFile.exists() && !this.tempFile.delete()) {
                    LOG.warn((Object)("Can't delete CAS temp file. Added to file cleaner. " + this.tempFile.getAbsolutePath()));
                    this.cleaner.addFile(this.tempFile);
                }
                throw new RecordAlreadyExistsException("Write error: " + e, e);
            }
            if (!this.vcasFile.exists()) {
                this.vcasFile.getParentFile().mkdirs();
                try {
                    DirectoryHelper.renameFile(this.tempFile, this.vcasFile);
                }
                catch (IOException e) {
                    throw new VCASException("File " + this.tempFile.getAbsolutePath() + " can't be renamed to VCAS-named " + this.vcasFile.getAbsolutePath(), e);
                }
            }
            if (!this.value.isByteArray() && this.value instanceof StreamPersistedValueData) {
                ((StreamPersistedValueData)this.value).setPersistedFile(this.vcasFile);
            }
        }
    }

    @Override
    public void twoPhaseCommit() throws IOException {
        if (this.fileLock != null) {
            this.tempFile.delete();
            this.fileLock.unlock();
        }
    }

    @Override
    public void rollback() throws IOException {
        if (this.fileLock != null) {
            try {
                this.tempFile.delete();
            }
            finally {
                this.fileLock.unlock();
            }
        }
    }
}

