/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchFilter;
import org.exoplatform.commons.search.es.ElasticSearchFilterType;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.storage.jcr.search.DocumentFileSearchResult;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.favorite.FavoriteService;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.json.simple.JSONObject;

public class DocumentSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(DocumentSearchServiceConnector.class);
    private ThreadLocal<String> filteredWorkspace = new ThreadLocal();
    private ThreadLocal<String> filteredPath = new ThreadLocal();
    private ThreadLocal<Identity> aclIdentity = new ThreadLocal();

    public DocumentSearchServiceConnector(ElasticSearchingClient client, InitParams initParams) {
        super(initParams, client);
    }

    protected String getSourceFields() {
        return "\"name\",\"workspace\",\"path\"";
    }

    protected String getFields() {
        return "\"title\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SearchResult> appSearch(Identity userIdentity, String workspace, String path, DocumentNodeFilter filter, int offset, int limit, String sort, String order) {
        this.aclIdentity.set(userIdentity);
        this.filteredWorkspace.set(workspace);
        if (StringUtils.isNotEmpty((String)path)) {
            if (path.endsWith("/")) {
                this.filteredPath.set(path);
            } else {
                this.filteredPath.set(path + "/");
            }
        }
        try {
            SearchContext context = new SearchContext(new Router(new ControllerDescriptor()), "");
            context.lang(Locale.ENGLISH.toString());
            ArrayList<ElasticSearchFilter> recentFilters = new ArrayList<ElasticSearchFilter>();
            boolean isfavorites = false;
            if (filter instanceof DocumentTimelineFilter) {
                isfavorites = BooleanUtils.isTrue((Boolean)((DocumentTimelineFilter)filter).getFavorites());
            }
            if (filter instanceof DocumentFolderFilter) {
                isfavorites = BooleanUtils.isTrue((Boolean)((DocumentFolderFilter)filter).getFavorites());
            }
            if (isfavorites) {
                Map<String, List<String>> metadataFilters = this.buildMetadataFilter();
                String metadataQuery = this.buildMetadataQueryStatement(metadataFilters);
                StringBuilder recentFilter = new StringBuilder();
                recentFilter.append(metadataQuery);
                recentFilters.add(new ElasticSearchFilter(ElasticSearchFilterType.FILTER_MATADATAS, "", recentFilter.toString()));
            }
            Collection collection = super.filteredSearch(context, filter.getQuery(), recentFilters, null, offset, limit, sort, order);
            return collection;
        }
        catch (Exception ex) {
            LOG.error((Object)"Can not create SearchContext", (Throwable)ex);
            List<SearchResult> list = Collections.emptyList();
            return list;
        }
        finally {
            this.aclIdentity.remove();
            this.filteredWorkspace.remove();
            this.filteredPath.remove();
        }
    }

    protected String getAdditionalFilters(List<ElasticSearchFilter> filters) {
        String workspace = this.filteredWorkspace.get();
        String path = this.filteredPath.get();
        if (StringUtils.isNotEmpty((String)workspace)) {
            filters = this.addFilter(filters, new ElasticSearchFilter(ElasticSearchFilterType.FILTER_BY_TERM, "workspace", workspace));
        }
        if (StringUtils.isNotEmpty((String)path)) {
            String titleFilterQuery = "{  \"prefix\" : {   \"path\" :  {    \"value\" : \"" + path + "\"   }  } }";
            filters = this.addFilter(filters, new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "", titleFilterQuery));
        }
        return super.getAdditionalFilters(filters);
    }

    protected SearchResult buildHit(JSONObject jsonHit, SearchContext searchContext) {
        SearchResult searchResult = super.buildHit(jsonHit, searchContext);
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String id = (String)jsonHit.get((Object)"_id");
        String workspace = (String)hitSource.get((Object)"workspace");
        String nodePath = (String)hitSource.get((Object)"path");
        return new DocumentFileSearchResult(searchResult, id, workspace, nodePath);
    }

    protected Set<String> getUserMemberships() {
        Identity userAclIdentity = this.aclIdentity.get();
        HashSet<String> entries = new HashSet<String>();
        for (MembershipEntry entry : userAclIdentity.getMemberships()) {
            if (entry.getMembershipType().equals("*")) {
                entries.add(entry.toString().replace("*", ".*"));
                continue;
            }
            entries.add(entry.toString());
            entries.add("*:" + entry.getGroup());
        }
        return entries;
    }

    private List<ElasticSearchFilter> addFilter(List<ElasticSearchFilter> filters, ElasticSearchFilter elasticSearchFilter) {
        if (filters == null) {
            filters = new ArrayList<ElasticSearchFilter>();
        }
        filters.add(elasticSearchFilter);
        return filters;
    }

    private String buildMetadataQueryStatement(Map<String, List<String>> metadataFilters) {
        StringBuilder metadataQuerySB = new StringBuilder();
        Set<Map.Entry<String, List<String>>> metadataFilterEntries = metadataFilters.entrySet();
        for (Map.Entry<String, List<String>> metadataFilterEntry : metadataFilterEntries) {
            metadataQuerySB.append("{\"terms\":{\"metadatas.").append(metadataFilterEntry.getKey()).append(".metadataName.keyword").append("\": [\"").append(StringUtils.join((Collection)metadataFilterEntry.getValue(), (String)"\",\"")).append("\"]}},");
        }
        return metadataQuerySB.toString();
    }

    private Map<String, List<String>> buildMetadataFilter() {
        org.exoplatform.social.core.identity.model.Identity viewerIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", this.aclIdentity.get().getUserId());
        HashMap<String, List<String>> metadataFilters = new HashMap<String, List<String>>();
        metadataFilters.put(FavoriteService.METADATA_TYPE.getName(), Collections.singletonList(viewerIdentity.getId()));
        return metadataFilters;
    }
}

