/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridEvaluator;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.image.DataType;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConvertedGridCoverage
extends GridCoverage {
    final GridCoverage source;
    private final MathTransform1D[] converters;
    private final boolean isConverted;
    private final DataType bandType;

    private ConvertedGridCoverage(GridCoverage gridCoverage, List<SampleDimension> list, MathTransform1D[] mathTransform1DArray, boolean bl) {
        super(gridCoverage.getGridGeometry(), list);
        this.source = gridCoverage;
        this.converters = mathTransform1DArray;
        this.isConverted = bl;
        this.bandType = ConvertedGridCoverage.getBandType(list, bl, gridCoverage);
    }

    static GridCoverage create(GridCoverage gridCoverage, boolean bl) throws NoninvertibleTransformException {
        ArrayList<SampleDimension> arrayList;
        List<SampleDimension> list = gridCoverage.getSampleDimensions();
        MathTransform1D[] mathTransform1DArray = ConvertedGridCoverage.converters(list, arrayList = new ArrayList<SampleDimension>(list.size()), bl);
        return mathTransform1DArray != null ? new ConvertedGridCoverage(gridCoverage, arrayList, mathTransform1DArray, bl) : gridCoverage;
    }

    static MathTransform1D[] converters(List<SampleDimension> list, List<SampleDimension> list2, boolean bl) throws NoninvertibleTransformException {
        int n = list.size();
        MathTransform1D mathTransform1D = (MathTransform1D)MathTransforms.identity((int)1);
        Object[] objectArray = new MathTransform1D[n];
        Arrays.fill(objectArray, mathTransform1D);
        for (int i = 0; i < n; ++i) {
            SampleDimension sampleDimension = list.get(i);
            SampleDimension sampleDimension2 = sampleDimension.forConvertedValues(bl);
            list2.add(sampleDimension2);
            if (sampleDimension == sampleDimension2) continue;
            Object object = sampleDimension.getTransferFunction().orElse(mathTransform1D);
            Optional<MathTransform1D> optional = sampleDimension2.getTransferFunction();
            if (optional.isPresent()) {
                object = MathTransforms.concatenate((MathTransform1D)object, (MathTransform1D)optional.get().inverse());
            }
            objectArray[i] = object;
        }
        for (Object object : objectArray) {
            if (object.isIdentity()) continue;
            return objectArray;
        }
        return null;
    }

    static DataType getBandType(List<SampleDimension> list, boolean bl, GridCoverage gridCoverage) {
        NumberRange numberRange = null;
        boolean bl2 = false;
        for (SampleDimension sampleDimension : list) {
            Optional<NumberRange<?>> optional = sampleDimension.getSampleRange();
            if (optional.isPresent()) {
                NumberRange numberRange2 = optional.get();
                if (numberRange == null) {
                    numberRange = numberRange2;
                } else {
                    if (numberRange instanceof MeasurementRange) {
                        numberRange = new NumberRange(numberRange);
                    }
                    numberRange = numberRange.unionAny(numberRange2);
                }
            }
            if (bl2) continue;
            bl2 = sampleDimension.allowsNaN();
        }
        if (numberRange == null) {
            return gridCoverage.getBandType();
        }
        Object object = DataType.forRange(numberRange, !bl);
        if (bl2) {
            object = ((DataType)((Object)object)).toFloat();
        }
        return object;
    }

    @Override
    final DataType getBandType() {
        return this.bandType;
    }

    @Override
    public GridEvaluator evaluator() {
        return new SampleConverter();
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        RenderedImage renderedImage = this.source.render(gridExtent);
        if (renderedImage != null) {
            renderedImage = this.convert(renderedImage, this.bandType, this.converters);
        }
        return renderedImage;
    }

    @Override
    public GridCoverage forConvertedValues(boolean bl) {
        return bl == this.isConverted ? this : this.source;
    }

    private final class SampleConverter
    extends GridEvaluator {
        private final GridEvaluator evaluator;

        SampleConverter() {
            super(ConvertedGridCoverage.this);
            this.evaluator = ConvertedGridCoverage.this.source.evaluator();
        }

        @Override
        public void setNullIfOutside(boolean bl) {
            this.evaluator.setNullIfOutside(bl);
            super.setNullIfOutside(bl);
        }

        @Override
        public double[] apply(DirectPosition directPosition) throws CannotEvaluateException {
            double[] dArray = this.evaluator.apply(directPosition);
            if (dArray != null) {
                try {
                    for (int i = 0; i < ConvertedGridCoverage.this.converters.length; ++i) {
                        dArray[i] = ConvertedGridCoverage.this.converters[i].transform(dArray[i]);
                    }
                }
                catch (TransformException transformException) {
                    throw new CannotEvaluateException(transformException.getMessage(), transformException);
                }
            }
            return dArray;
        }
    }
}

