/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.oauth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.register.UIRegisterOAuth;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.web.security.AuthenticationRegistry;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.security.oauth.exception.OAuthException;
import org.gatein.security.oauth.exception.OAuthExceptionCode;

public class OAuthLifecycle
implements ApplicationLifecycle<PortalRequestContext> {
    private final Log log = ExoLogger.getLogger(OAuthLifecycle.class);
    private AuthenticationRegistry authRegistry;

    public void onInit(Application app) throws Exception {
        this.authRegistry = (AuthenticationRegistry)app.getApplicationServiceContainer().getComponentInstanceOfType(AuthenticationRegistry.class);
    }

    public void onStartRequest(Application app, PortalRequestContext context) throws Exception {
        ApplicationMessage appMessage;
        OAuthException gtnOAuthException;
        String socialNetworkName;
        HttpServletRequest httpRequest = context.getRequest();
        HttpSession httpSession = httpRequest.getSession();
        UIPortalApplication uiApp = Util.getUIPortalApplication();
        User oauthAuthenticatedUser = (User)this.authRegistry.getAttributeOfClient(httpRequest, "_authenticatedPortalUser");
        if (oauthAuthenticatedUser != null) {
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found user, which has been authenticated through OAuth. Username is " + oauthAuthenticatedUser.getUserName()));
            }
            if (!uiMaskWS.isShow() || !uiMaskWS.getUIComponent().getClass().equals(UIRegisterOAuth.class)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Showing registration form for OAuth registration");
                }
                UIRegisterOAuth uiRegisterOauth = uiMaskWS.createUIComponent(UIRegisterOAuth.class, null, null);
                uiMaskWS.setUIComponent((UIComponent)uiRegisterOauth);
            }
        }
        if ((socialNetworkName = (String)httpSession.getAttribute("_linkedOAuthProviderUsernameAttrName")) != null) {
            httpSession.removeAttribute("_linkedOAuthProviderUsernameAttrName");
            ApplicationMessage msg = new ApplicationMessage("UIAccountSocial.msg.successful-link", new Object[]{socialNetworkName, context.getRemoteUser()});
            msg.setArgsLocalized(false);
            uiApp.addMessage(msg);
        }
        if ((gtnOAuthException = (OAuthException)httpSession.getAttribute("_oauthExceptionAfterFailedLink")) != null) {
            httpSession.removeAttribute("_oauthExceptionAfterFailedLink");
            Object[] args = new Object[]{gtnOAuthException.getExceptionAttribute("OAuthProviderUsername"), gtnOAuthException.getExceptionAttribute("OAuthProviderName")};
            appMessage = new ApplicationMessage("UIAccountSocial.msg.failed-link", args, 1);
            appMessage.setArgsLocalized(false);
            uiApp.addMessage(appMessage);
        }
        if ((gtnOAuthException = (OAuthException)httpSession.getAttribute("_oauthException")) != null) {
            String key;
            httpSession.removeAttribute("_oauthException");
            if (gtnOAuthException.getExceptionCode() == OAuthExceptionCode.USER_DENIED_SCOPE) {
                key = "UIAccountSocial.msg.access-denied";
            } else {
                key = "UIAccountSocial.msg.oauth-error";
                this.log.error((Object)"Unspecified error during OAuth flow", (Throwable)gtnOAuthException);
            }
            appMessage = new ApplicationMessage(key, null, 1);
            uiApp.addMessage(appMessage);
        }
    }

    public void onFailRequest(Application app, PortalRequestContext context, RequestFailure failureType) {
    }

    public void onEndRequest(Application app, PortalRequestContext context) throws Exception {
    }

    public void onDestroy(Application app) throws Exception {
    }
}

