/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.lan;

import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.code.MD_CharacterSetCode;
import org.apache.sis.internal.jaxb.lan.Country;
import org.apache.sis.internal.jaxb.lan.LanguageCode;
import org.apache.sis.internal.util.CollectionsExt;

public final class PT_Locale {
    private Locale locale;
    @XmlElement(name="PT_Locale")
    private Wrapper element;

    private PT_Locale() {
    }

    public PT_Locale(Locale locale) {
        this.locale = locale;
    }

    private PT_Locale(Map.Entry<Locale, Charset> entry) {
        this.locale = entry.getKey();
        this.setCharacterSet(entry.getValue());
    }

    public Locale getLocale() {
        if (this.locale == null && this.element != null) {
            this.locale = Country.getLocale(Context.current(), this.element.language, this.element.country, PT_Locale.class);
        }
        return this.locale;
    }

    final Charset getCharacterSet() {
        return this.element != null ? this.element.characterEncoding : null;
    }

    final void setCharacterSet(Charset charset) {
        this.element = new Wrapper(this.locale, charset);
    }

    final boolean addInto(Map<Locale, Charset> map) {
        Locale locale = this.getLocale();
        Charset charset = this.getCharacterSet();
        if (locale != null || charset != null) {
            boolean bl = charset == null && !map.containsKey(locale);
            return map.put(locale, charset) != charset | bl;
        }
        return false;
    }

    public static PT_Locale first(Map<Locale, Charset> map) {
        Map.Entry entry;
        if (map != null && (entry = (Map.Entry)CollectionsExt.first(map.entrySet())) != null) {
            return new PT_Locale(entry);
        }
        return null;
    }

    public static Set<PT_Locale> wrap(Map<Locale, Charset> map) {
        return map != null && !map.isEmpty() ? new Sequence(map) : null;
    }

    @XmlType(name="PT_Locale_Type", propOrder={"languageCode", "language", "country", "characterEncoding"})
    private static final class Wrapper {
        LanguageCode language;
        @XmlElement
        Country country;
        @XmlElement(required=true)
        @XmlJavaTypeAdapter(value=MD_CharacterSetCode.class)
        Charset characterEncoding;
        private boolean isLegacyMetadata;

        public Wrapper() {
        }

        Wrapper(Locale locale, Charset charset) {
            Context context = Context.current();
            this.isLegacyMetadata = Context.isFlagSet(context, 32);
            this.language = LanguageCode.create(context, locale);
            this.country = Country.create(context, locale);
            this.characterEncoding = charset;
        }

        @XmlElement(name="languageCode", namespace="http://www.isotc211.org/2005/gmd")
        private LanguageCode getLanguageCode() {
            return this.isLegacyMetadata ? this.language : null;
        }

        private void setLanguageCode(LanguageCode languageCode) {
            this.language = languageCode;
        }

        @XmlElement(name="language", required=true)
        private LanguageCode getLanguage() {
            return this.isLegacyMetadata ? null : this.language;
        }

        private void setLanguage(LanguageCode languageCode) {
            this.language = languageCode;
        }

        public void beforeMarshal(Marshaller marshaller) {
            if (this.characterEncoding == null) {
                String string;
                try {
                    string = (String)marshaller.getProperty("jaxb.encoding");
                }
                catch (ClassCastException | PropertyException throwable) {
                    Context.warningOccured(Context.current(), PT_Locale.class, "beforeMarshal", (Exception)throwable, true);
                    return;
                }
                if (string != null) {
                    Context context = Context.current();
                    this.characterEncoding = Context.converter(context).toCharset(context, string);
                }
            }
        }
    }

    private static final class Sequence
    extends AbstractSet<PT_Locale> {
        final Map<Locale, Charset> locales;

        Sequence(Map<Locale, Charset> map) {
            this.locales = map;
        }

        @Override
        public int size() {
            return this.locales.size();
        }

        @Override
        public boolean add(PT_Locale pT_Locale) {
            return pT_Locale != null && pT_Locale.addInto(this.locales);
        }

        @Override
        public Iterator<PT_Locale> iterator() {
            final Iterator<Map.Entry<Locale, Charset>> iterator = this.locales.entrySet().iterator();
            return new Iterator<PT_Locale>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public PT_Locale next() {
                    return new PT_Locale((Map.Entry)iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }
    }
}

