/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.simple.SimpleAttributeType;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.Containers;
import org.opengis.util.MemberName;
import org.opengis.util.RecordType;
import org.opengis.util.Type;

@XmlTransient
abstract class RecordDefinition {
    private transient Map<MemberName, Integer> fieldIndices;
    private transient MemberName[] fieldNames;
    private transient Class<?>[] valueClasses;
    private transient Class<?> baseValueClass;

    RecordDefinition() {
    }

    abstract RecordType getRecordType();

    final Type[] computeTransientFields(Map<? extends MemberName, ? extends Type> map) {
        int n = map.size();
        this.fieldNames = new MemberName[n];
        this.fieldIndices = new LinkedHashMap<MemberName, Integer>(Containers.hashMapCapacity((int)n));
        Type[] typeArray = new Type[n];
        int n2 = 0;
        for (Map.Entry<? extends MemberName, ? extends Type> entry : map.entrySet()) {
            MemberName memberName;
            Type type = entry.getValue();
            if (type instanceof SimpleAttributeType && (memberName = ((SimpleAttributeType)type).getValueClass()) != Object.class) {
                if (this.valueClasses == null) {
                    this.valueClasses = new Class[n];
                }
                this.valueClasses[n2] = memberName;
                this.baseValueClass = Classes.findCommonClass(this.baseValueClass, (Class)memberName);
            }
            this.fieldNames[n2] = memberName = entry.getKey();
            this.fieldIndices.put(memberName, n2);
            typeArray[n2] = type;
            ++n2;
        }
        this.fieldIndices = CollectionsExt.unmodifiableOrCopy(this.fieldIndices);
        this.baseValueClass = this.baseValueClass != null ? Numbers.wrapperToPrimitive(this.baseValueClass) : Object.class;
        return typeArray;
    }

    final Class<?> baseValueClass() {
        return this.baseValueClass;
    }

    final Map<MemberName, Integer> fieldIndices() {
        return this.fieldIndices;
    }

    final int size() {
        return this.fieldNames != null ? this.fieldNames.length : 0;
    }

    final Integer indexOf(MemberName memberName) {
        return this.fieldIndices.get(memberName);
    }

    final MemberName getName(int n) {
        return this.fieldNames[n];
    }

    final Class<?> getValueClass(int n) {
        return this.valueClasses != null ? this.valueClasses[n] : null;
    }

    public String toString() {
        return this.toString("RecordType", null);
    }

    final String toString(String string, Object object) {
        String string2;
        int n;
        StringBuilder stringBuilder = new StringBuilder(250);
        String string3 = System.lineSeparator();
        String[] stringArray = new String[this.size()];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = this.fieldNames[n].toString();
            n2 = Math.max(n2, stringArray[n].length());
        }
        if (string == null) {
            n2 = 0;
            string2 = "";
        } else {
            stringBuilder.append(string).append("[\u201c").append(this.getRecordType().getTypeName()).append("\u201d] {").append(string3);
            string2 = "    ";
        }
        for (n = 0; n < stringArray.length; ++n) {
            Object object2;
            String string4 = stringArray[n];
            stringBuilder.append(string2).append(string4);
            Object object3 = object2 = object != null ? Array.get(object, n) : this.fieldNames[n].getAttributeType();
            if (object2 != null) {
                stringBuilder.append(CharSequences.spaces((int)(n2 - string4.length()))).append(" : ").append(object2);
            }
            stringBuilder.append(string3);
        }
        if (string != null) {
            stringBuilder.append('}').append(string3);
        }
        return stringBuilder.toString();
    }

    static final class Adapter
    extends RecordDefinition
    implements Serializable {
        private static final long serialVersionUID = 3739362257927222288L;
        private final RecordType recordType;

        Adapter(RecordType recordType) {
            this.recordType = recordType;
            this.computeTransientFields(recordType.getMemberTypes());
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.computeTransientFields(this.recordType.getMemberTypes());
        }

        @Override
        RecordType getRecordType() {
            return this.recordType;
        }
    }
}

