/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

public abstract class ByteArrayValueData
extends AbstractValueData {
    protected byte[] value;

    protected ByteArrayValueData(int orderNumber, byte[] value) {
        super(orderNumber);
        this.value = value;
    }

    @Override
    protected boolean internalEquals(ValueData another) {
        if (another instanceof ByteArrayValueData) {
            return Arrays.equals(((ByteArrayValueData)another).value, this.value);
        }
        return false;
    }

    @Override
    protected byte[] spoolInternalValue() {
        return this.value;
    }

    @Override
    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new ByteArrayPersistedValueData(orderNumber, this.value);
    }

    @Override
    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    @Override
    protected Long getLong() throws ValueFormatException {
        return Long.valueOf(this.getString());
    }

    @Override
    protected Boolean getBoolean() throws ValueFormatException {
        return Boolean.valueOf(this.getString());
    }

    @Override
    protected Double getDouble() throws ValueFormatException {
        return Double.valueOf(this.getString());
    }

    @Override
    protected String getString() throws ValueFormatException {
        try {
            return new String(this.value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ValueFormatException("Unsupported encoding UTF-8", (Throwable)e);
        }
    }

    @Override
    protected Calendar getDate() throws ValueFormatException {
        return JCRDateFormat.parse(this.getString());
    }

    @Override
    protected InternalQName getName() throws ValueFormatException, IllegalNameException {
        return InternalQName.parse(this.getString());
    }

    @Override
    protected QPath getPath() throws ValueFormatException, IllegalPathException {
        return QPath.parse(this.getString());
    }

    @Override
    protected String getReference() throws ValueFormatException {
        return this.getString();
    }

    @Override
    protected AccessControlEntry getPermission() throws ValueFormatException {
        return AccessControlEntry.parse(this.getString());
    }
}

