/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.impl.dataflow.persistent.infinispan.BufferedISPNCache;
import org.exoplatform.services.jcr.infinispan.CacheKey;

public class CompressedISPNChangesBuffer {
    private int historyIndex = 0;
    private final List<BufferedISPNCache.ChangesContainer> changes = new ArrayList<BufferedISPNCache.ChangesContainer>();
    private final Map<CacheKey, Object> lastChanges = new HashMap<CacheKey, Object>();

    public void add(BufferedISPNCache.ChangesContainer container) {
        this.changes.add(container);
        container.applyToBuffer(this);
    }

    public int getHistoryIndex() {
        ++this.historyIndex;
        return this.historyIndex;
    }

    public List<BufferedISPNCache.ChangesContainer> getSortedList() {
        ArrayList<BufferedISPNCache.ChangesContainer> changesContainers = new ArrayList<BufferedISPNCache.ChangesContainer>(this.changes);
        Collections.sort(changesContainers);
        return changesContainers;
    }

    Object get(CacheKey key) {
        return this.lastChanges.get(key);
    }

    void put(CacheKey key, Object value) {
        this.lastChanges.put(key, value);
    }

    public Map<CacheKey, Object> getLastChanges() {
        return this.lastChanges;
    }
}

