/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.CachingContainer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.InstanceComponentAdapter;
import org.exoplatform.container.LifecycleVisitor;
import org.exoplatform.container.management.ManageableComponentAdapterFactory;
import org.exoplatform.container.security.ContainerPermissions;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ComponentAdapterFactory;
import org.exoplatform.container.spi.Container;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.spi.ContainerVisitor;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ConcurrentContainer
extends AbstractInterceptor {
    private static final long serialVersionUID = -2275793454555604533L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ConcurrentContainer");
    protected final ConcurrentMap<Object, ComponentAdapter<?>> componentKeyToAdapterCache = new ConcurrentHashMap();
    private ComponentAdapterFactory componentAdapterFactory;
    protected final Set<ComponentAdapter<?>> componentAdapters = new CopyOnWriteArraySet();
    protected final CopyOnWriteArrayList<ComponentAdapter<?>> orderedComponentAdapters = new CopyOnWriteArrayList();
    protected final Set<ExoContainer> children = new CopyOnWriteArraySet<ExoContainer>();
    private volatile CachingContainer cache;
    private final transient ThreadLocal<Map<Object, CreationalContextComponentAdapter<?>>> depResolutionCtx = new ThreadLocal();

    public ConcurrentContainer() {
    }

    public ConcurrentContainer(ExoContainer holder, ExoContainer parent) {
        this.setParent(parent);
        this.setHolder(holder);
    }

    @Override
    public Collection<ComponentAdapter<?>> getComponentAdapters() {
        return Collections.unmodifiableSet(this.componentAdapters);
    }

    @Override
    public void setHolder(ExoContainer holder) {
        this.holder = holder;
        this.componentAdapterFactory = this.getDefaultComponentAdapterFactory();
    }

    protected ComponentAdapterFactory getDefaultComponentAdapterFactory() {
        return new ManageableComponentAdapterFactory(this.holder, this);
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapter(Object componentKey, Class<T> bindType, boolean autoRegistration) throws ContainerException {
        ComponentAdapter<T> adapter = (ComponentAdapter<T>)this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey, bindType, autoRegistration);
        }
        if (adapter != null && !bindType.isAssignableFrom(adapter.getComponentImplementation())) {
            throw new ClassCastException("The adpater found is not of the expected type which was " + bindType.getName() + " and the implementation type is " + adapter.getComponentImplementation().getName());
        }
        return adapter;
    }

    @Override
    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> adapterByKey = this.getComponentAdapter(componentType, componentType, autoRegistration);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List<ComponentAdapter<T>> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType, autoRegistration);
            }
            return null;
        }
        Class[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter<T> componentAdapter = found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new ContainerException("Several ComponentAdapter found for " + componentType);
    }

    @Override
    public <T> List<ComponentAdapter<T>> getComponentAdaptersOfType(Class<T> componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList<ComponentAdapter<T>> found = new ArrayList<ComponentAdapter<T>>();
        for (ComponentAdapter<?> componentAdapter : this.componentAdapters) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        return found;
    }

    protected ComponentAdapter<?> registerComponent(ComponentAdapter<?> componentAdapter) throws ContainerException {
        Object componentKey;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_COMPONENT_PERMISSION);
        }
        if (this.componentKeyToAdapterCache.putIfAbsent(componentKey = componentAdapter.getComponentKey(), componentAdapter) != null) {
            throw new ContainerException("Key " + componentKey + " duplicated");
        }
        this.componentAdapters.add(componentAdapter);
        return componentAdapter;
    }

    @Override
    public ComponentAdapter<?> unregisterComponent(Object componentKey) {
        Object value;
        ComponentAdapter adapter;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ContainerPermissions.MANAGE_COMPONENT_PERMISSION);
        }
        if ((adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey)) instanceof InstanceComponentAdapter && (value = adapter.getComponentInstance()) instanceof Container) {
            this.children.remove((Container)value);
        }
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ComponentAdapter<T> registerComponentInstance(Object componentKey, T componentInstance) throws ContainerException {
        if (componentInstance instanceof ExoContainer) {
            ExoContainer pc = (ExoContainer)componentInstance;
            Object contrivedKey = new Object();
            String contrivedComp = "";
            pc.registerComponentInstance(contrivedKey, contrivedComp);
            try {
                if (this.getComponentInstance(contrivedKey, Object.class, false) != null) {
                    throw new ContainerException("Cannot register a container to itself. The container is already implicitly registered.");
                }
            }
            finally {
                pc.unregisterComponent(contrivedKey);
            }
            this.children.add(pc);
        }
        InstanceComponentAdapter<T> componentAdapter = new InstanceComponentAdapter<T>(componentKey, componentInstance);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    @Override
    public <T> ComponentAdapter<T> registerComponentImplementation(Object componentKey, Class<T> componentImplementation) throws ContainerException {
        ComponentAdapter<T> componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    protected void addOrderedComponentAdapter(ComponentAdapter<?> componentAdapter) {
        this.orderedComponentAdapters.addIfAbsent(componentAdapter);
    }

    public List<Object> getComponentInstances() throws ContainerException {
        return this.getComponentInstancesOfType(Object.class);
    }

    @Override
    public <T> List<T> getComponentInstancesOfType(Class<T> componentType) throws ContainerException {
        if (componentType == null) {
            return Collections.emptyList();
        }
        HashMap adapterToInstanceMap = new HashMap();
        for (ComponentAdapter<?> componentAdapter : this.componentAdapters) {
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            Object componentInstance = this.getInstance(componentAdapter, componentType, false);
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (ComponentAdapter<?> componentAdapter : this.orderedComponentAdapters) {
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentType.cast(componentInstance));
        }
        return result;
    }

    @Override
    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) throws ContainerException {
        ComponentAdapter<T> componentAdapter = this.getComponentAdapter(componentKey, bindType, autoRegistration);
        if (componentAdapter == null) {
            return null;
        }
        T value = this.getComponentInstanceFromContext(componentAdapter, bindType);
        return value != null ? value : this.getInstance(componentAdapter, bindType, autoRegistration);
    }

    protected <T> T getComponentInstanceFromContext(ComponentAdapter<T> componentAdapter, Class<T> bindType) {
        CreationalContextComponentAdapter<?> result;
        Map<Object, CreationalContextComponentAdapter<?>> map = this.depResolutionCtx.get();
        if (map != null && (result = map.get(componentAdapter.getComponentKey())) != null && result.get() != null) {
            this.getCache().disable();
            return bindType.cast(result.get());
        }
        return null;
    }

    @Override
    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> componentAdapter = this.getComponentAdapterOfType(componentType, autoRegistration);
        if (componentAdapter == null) {
            return null;
        }
        T value = this.getComponentInstanceFromContext(componentAdapter, componentType);
        return value != null ? value : this.getInstance(componentAdapter, componentType, autoRegistration);
    }

    public <T> CreationalContextComponentAdapter<T> addComponentToCtx(Object key) {
        CreationalContextComponentAdapter<Object> result;
        Map<Object, CreationalContextComponentAdapter<?>> map = this.depResolutionCtx.get();
        if (map == null) {
            map = new HashMap();
            this.depResolutionCtx.set(map);
        }
        if ((result = map.get(key)) == null) {
            result = new CreationalContextComponentAdapter();
            map.put(key, result);
        }
        return result;
    }

    public void removeComponentFromCtx(Object key) {
        Map<Object, CreationalContextComponentAdapter<?>> map = this.depResolutionCtx.get();
        if (map != null) {
            map.remove(key);
            if (map.isEmpty()) {
                this.depResolutionCtx.set(null);
            }
        }
    }

    protected <T> T getInstance(ComponentAdapter<T> componentAdapter, Class<T> type, boolean autoRegistration) {
        boolean isLocal = this.componentAdapters.contains(componentAdapter);
        if (isLocal) {
            T instance = componentAdapter.getComponentInstance();
            this.addOrderedComponentAdapter(componentAdapter);
            if (!componentAdapter.isSingleton()) {
                this.getCache().disable();
            }
            return instance;
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey(), type, autoRegistration);
        }
        return null;
    }

    @Override
    public void start() {
        LifecycleVisitor.start(this);
    }

    @Override
    public void stop() {
        LifecycleVisitor.stop(this);
    }

    @Override
    public void dispose() {
        LifecycleVisitor.dispose(this);
    }

    @Override
    public void accept(ContainerVisitor visitor) {
        visitor.visitContainer(this.holder);
        for (ExoContainer child : this.children) {
            child.accept(visitor);
        }
    }

    public ExoContainer getHolder() {
        return this.holder;
    }

    @Override
    public ManagementContext getManagementContext() {
        return null;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return null;
    }

    @Override
    public ObjectName getScopingObjectName() {
        return null;
    }

    public <T> T createComponent(Class<T> clazz) throws Exception {
        return this.createComponent(clazz, null);
    }

    @Override
    public <T> T createComponent(Class<T> clazz, InitParams params) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(clazz.getName() + " " + (Serializable)(params != null ? params : "") + " added to " + this.getHolder().getContext().getName()));
        }
        Constructor[] constructors = new Constructor[]{};
        try {
            constructors = ContainerUtil.getSortedConstructors(clazz);
        }
        catch (NoClassDefFoundError err) {
            throw new Exception("Cannot resolve constructor for class " + clazz.getName(), err);
        }
        Class<?> unknownParameter = null;
        for (int k = 0; k < constructors.length; ++k) {
            Constructor constructor = constructors[k];
            Class<?>[] parameters = constructor.getParameterTypes();
            Object[] args = new Object[parameters.length];
            boolean constructorWithInject = constructors.length == 1 && constructor.isAnnotationPresent(Inject.class);
            boolean satisfied = true;
            String logMessagePrefix = null;
            Type[] genericTypes = null;
            Annotation[][] parameterAnnotations = null;
            if (constructorWithInject) {
                genericTypes = constructor.getGenericParameterTypes();
                parameterAnnotations = constructor.getParameterAnnotations();
            }
            if (LOG.isDebugEnabled() && constructorWithInject) {
                logMessagePrefix = "Could not call the constructor of the class " + clazz.getName();
            }
            for (int i = 0; i < args.length; ++i) {
                if (parameters[i].equals(InitParams.class)) {
                    args[i] = params;
                    continue;
                }
                if (constructorWithInject) {
                    Object result = this.resolveType(parameters[i], genericTypes[i], parameterAnnotations[i], logMessagePrefix);
                    if (!(result instanceof Integer)) {
                        args[i] = result;
                    }
                } else {
                    args[i] = this.holder.getComponentInstanceOfType(parameters[i]);
                }
                if (args[i] != null) continue;
                satisfied = false;
                unknownParameter = parameters[i];
                break;
            }
            if (!satisfied) continue;
            if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
                constructor.setAccessible(true);
            }
            return clazz.cast(constructor.newInstance(args));
        }
        throw new Exception("Cannot find a satisfying constructor for " + clazz.getName() + " with parameter " + unknownParameter);
    }

    public <T> boolean initializeComponent(T instance) {
        LinkedList hierarchy = new LinkedList();
        Class<?> clazz = instance.getClass();
        do {
            hierarchy.addFirst(clazz);
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        HashMap<String, Method> methodAlreadyRegistered = new HashMap<String, Method>();
        HashMap methodsPerClass = new HashMap();
        for (Class clazz2 : hierarchy) {
            this.addMethods(clazz2, methodAlreadyRegistered, methodsPerClass);
        }
        boolean isInjectPresent = !methodAlreadyRegistered.isEmpty();
        for (Class clazz3 : hierarchy) {
            if (this.initializeFields(instance, clazz3)) {
                isInjectPresent = true;
            }
            this.initializeMethods(instance, (Collection)methodsPerClass.get(clazz3));
        }
        return isInjectPresent;
    }

    protected void addMethods(Class<?> c, Map<String, Method> methodAlreadyRegistered, Map<Class<?>, Collection<Method>> methodsPerClass) {
        for (Method m : c.getDeclaredMethods()) {
            Collection<Method> cMethods;
            String id;
            boolean addMethod = false;
            Method methodToRemove = null;
            if (m.isAnnotationPresent(Inject.class)) {
                addMethod = true;
                methodToRemove = methodAlreadyRegistered.put(ConcurrentContainer.getMethodId(m), m);
            } else if (!methodAlreadyRegistered.isEmpty() && methodAlreadyRegistered.containsKey(id = ConcurrentContainer.getMethodId(m))) {
                addMethod = true;
                methodToRemove = methodAlreadyRegistered.put(id, m);
            }
            if (addMethod) {
                cMethods = methodsPerClass.get(c);
                if (cMethods == null) {
                    cMethods = new HashSet<Method>();
                    methodsPerClass.put(c, cMethods);
                }
                cMethods.add(m);
            }
            if (methodToRemove == null || (cMethods = methodsPerClass.get(methodToRemove.getDeclaringClass())) == null) continue;
            cMethods.remove(methodToRemove);
        }
    }

    private <T> void initializeMethods(T instance, Collection<Method> methods) {
        if (methods == null) {
            return;
        }
        block2: for (Method m : methods) {
            if (!m.isAnnotationPresent(Inject.class)) continue;
            if (Modifier.isAbstract(m.getModifiers())) {
                LOG.warn((Object)("Could not call the method " + m.getName() + " of the class " + instance.getClass().getName() + ": The method cannot be abstract"));
                continue;
            }
            if (Modifier.isStatic(m.getModifiers())) {
                LOG.warn((Object)("Could not call the method " + m.getName() + " of the class " + instance.getClass().getName() + ": The method cannot be static"));
                continue;
            }
            Class<?>[] paramTypes = m.getParameterTypes();
            Object[] params = new Object[paramTypes.length];
            Type[] genericTypes = m.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = m.getParameterAnnotations();
            String logMessagePrefix = null;
            if (LOG.isDebugEnabled()) {
                logMessagePrefix = "Could not call the method " + m.getName() + " of the class " + instance.getClass().getName();
            }
            int l = paramTypes.length;
            for (int j = 0; j < l; ++j) {
                Object result = this.resolveType(paramTypes[j], genericTypes[j], parameterAnnotations[j], logMessagePrefix);
                if (result instanceof Integer) {
                    int r = (Integer)result;
                    if (r == 1 || r == 2) continue block2;
                    params[j] = null;
                    continue;
                }
                params[j] = result;
            }
            try {
                if (!(Modifier.isPublic(m.getModifiers()) && Modifier.isPublic(m.getDeclaringClass().getModifiers()) || m.isAccessible())) {
                    m.setAccessible(true);
                }
                m.invoke(instance, params);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not call the method " + m.getName() + " of the class " + instance.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
    }

    private static String getMethodId(Method m) {
        StringBuilder sb = new StringBuilder();
        int modifier = m.getModifiers();
        if (Modifier.isPrivate(modifier)) {
            sb.append(m.getDeclaringClass().getName());
        } else if (!Modifier.isPublic(modifier) && !Modifier.isProtected(modifier)) {
            sb.append(m.getDeclaringClass().getPackage().getName());
        }
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] paramTypes = m.getParameterTypes();
        int l = paramTypes.length;
        for (int i = 0; i < l; ++i) {
            sb.append(paramTypes[i].getName());
            if (i >= i - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    private <T> boolean initializeFields(T instance, Class<?> clazz) {
        boolean isInjectPresent = false;
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Inject.class)) continue;
            isInjectPresent = true;
            if (Modifier.isFinal(f.getModifiers())) {
                LOG.warn((Object)("Could not set a value to the field " + f.getName() + " of the class " + instance.getClass().getName() + ": The field cannot be final"));
                continue;
            }
            if (Modifier.isStatic(f.getModifiers())) {
                LOG.warn((Object)("Could not set a value to the field " + f.getName() + " of the class " + instance.getClass().getName() + ": The field cannot be static"));
                continue;
            }
            try {
                Object result;
                if (!(Modifier.isPublic(f.getModifiers()) && Modifier.isPublic(f.getDeclaringClass().getModifiers()) || f.isAccessible())) {
                    f.setAccessible(true);
                }
                String logMessagePrefix = null;
                if (LOG.isDebugEnabled()) {
                    logMessagePrefix = "Could not set a value to the field " + f.getName() + " of the class " + instance.getClass().getName();
                }
                if ((result = this.resolveType(f.getType(), f.getGenericType(), f.getAnnotations(), logMessagePrefix)) instanceof Integer) continue;
                f.set(instance, result);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set a value to the field " + f.getName() + " of the class " + instance.getClass().getName() + ": " + e.getMessage(), e);
            }
        }
        return isInjectPresent;
    }

    private Object resolveType(Class<?> type, Type genericType, Annotation[] annotations, String logMessagePrefix) {
        if (type.isPrimitive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(logMessagePrefix + ": Primitive types are not supported"));
            }
            return 1;
        }
        Named named = null;
        Class<? extends Annotation> qualifier = null;
        for (Annotation a : annotations) {
            if (a instanceof Named) {
                named = (Named)a;
                break;
            }
            if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            qualifier = a.annotationType();
            break;
        }
        if (type.isInterface() && type.equals(Provider.class)) {
            if (!(genericType instanceof ParameterizedType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(logMessagePrefix + ": The generic type is not of type ParameterizedType"));
                }
                return 2;
            }
            ParameterizedType aType = (ParameterizedType)genericType;
            Type[] typeVars = aType.getActualTypeArguments();
            Class expectedType = (Class)typeVars[0];
            final ComponentAdapter adapter = named != null ? this.holder.getComponentAdapter(named.value(), expectedType) : (qualifier != null ? this.holder.getComponentAdapter(qualifier, expectedType) : this.holder.getComponentAdapterOfType(expectedType));
            if (adapter == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(logMessagePrefix + ": We have no value to set so we skip it"));
                }
                return 3;
            }
            return new Provider<Object>(){

                public Object get() {
                    return adapter.getComponentInstance();
                }
            };
        }
        if (named != null) {
            return this.holder.getComponentInstance(named.value(), type);
        }
        if (qualifier != null) {
            return this.holder.getComponentInstance(qualifier, type);
        }
        return this.holder.getComponentInstanceOfType(type);
    }

    @Override
    public void initialize() {
    }

    protected CachingContainer getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        Container co = this.holder;
        do {
            if (!(co instanceof CachingContainer)) continue;
            this.cache = (CachingContainer)co;
        } while ((co = co.getSuccessor()) != null);
        return this.cache;
    }

    public static class CreationalContextComponentAdapter<T>
    implements CreationalContext<T> {
        private T instance;

        public void push(T incompleteInstance) {
            this.instance = incompleteInstance;
        }

        public void release() {
        }

        public T get() {
            return this.instance;
        }
    }
}

