/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import javax.servlet.ServletContext;
import org.exoplatform.container.util.ContainerUtil;

public class WebAppInitContext {
    private final ServletContext servletContext;
    private final String servletContextName;
    private final ClassLoader webappClassLoader;

    public WebAppInitContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.webappClassLoader = Thread.currentThread().getContextClassLoader();
        this.servletContextName = ContainerUtil.getServletContextName(servletContext);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public ClassLoader getWebappClassLoader() {
        return this.webappClassLoader;
    }

    public boolean equals(Object o) {
        if (o instanceof WebAppInitContext) {
            return this.getServletContextName().equals(((WebAppInitContext)o).getServletContextName());
        }
        return false;
    }

    public int hashCode() {
        return this.getServletContextName().hashCode();
    }
}

