/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.descriptor;

import java.util.Collection;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ControllerHandler;
import juzu.request.Phase;

class ControllerDescriptorResolver
extends ControllerResolver<ControllerHandler> {
    private final ControllersDescriptor desc;
    private final ControllerHandler[] handlers;

    ControllerDescriptorResolver(ControllersDescriptor desc) throws NullPointerException {
        this.handlers = desc.getHandlers().toArray(new ControllerHandler[desc.getHandlers().size()]);
        this.desc = desc;
    }

    public ControllerHandler[] getHandlers() {
        return this.handlers;
    }

    @Override
    public String getId(ControllerHandler handler) {
        return handler.getId();
    }

    @Override
    public Phase getPhase(ControllerHandler handler) {
        return handler.getPhase();
    }

    @Override
    public String getName(ControllerHandler handler) {
        return handler.getName();
    }

    @Override
    public boolean isDefault(ControllerHandler handler) {
        return handler.getType() == this.desc.getDefaultController() || this.desc.getControllers().size() < 2;
    }

    @Override
    public Collection<String> getParameterNames(ControllerHandler handler) {
        return handler.getParameterNames();
    }
}

