/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class MentionUtils {
    private static final Pattern MENTION_PATTERN = Pattern.compile("@([^\\s<]+)|@([^\\s<]+)$");
    private static final Log LOG = ExoLogger.getLogger(MentionUtils.class);

    public static String substituteUsernames(String portalOwner, String message) {
        if (message == null || message.trim().isEmpty()) {
            return message;
        }
        Matcher matcher = MENTION_PATTERN.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            IdentityManager identityManager;
            Identity identity;
            String username = matcher.group().substring(1);
            if (username == null || username.isEmpty() || (identity = (identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", username)) == null || identity.isDeleted() || !identity.isEnable()) continue;
            try {
                username = LinkProvider.getProfileLink(username, portalOwner);
            }
            catch (Exception e) {
                LOG.warn("Error while retrieving link for profile of user {}", new Object[]{username, e});
                continue;
            }
            if (username == null) continue;
            matcher.appendReplacement(buf, username);
        }
        if (buf.length() > 0) {
            matcher.appendTail(buf);
            return buf.toString();
        }
        return message;
    }
}

