/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.tm;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.ehcache.hibernate.tm.SyncTransaction;
import net.sf.ehcache.hibernate.tm.TransactionSynchronization;

public final class SyncTransactionManager
implements TransactionManager {
    private static final ThreadLocal<Transaction> CURRENT_TX = new ThreadLocal();
    private final TransactionManager transactionManager;

    public SyncTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.requiresTx(false);
        Transaction underlyingTx = this.transactionManager.getTransaction();
        if (underlyingTx == null) {
            throw new IllegalStateException();
        }
        SyncTransaction transaction = new SyncTransaction(this);
        try {
            underlyingTx.registerSynchronization((Synchronization)new TransactionSynchronization(transaction));
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        this.setTransaction(transaction);
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.transactionManager.commit();
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public Transaction getTransaction() throws SystemException {
        Transaction transaction = CURRENT_TX.get();
        if (transaction == null) {
            try {
                this.begin();
                transaction = this.getTransaction();
            }
            catch (NotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }
        return transaction;
    }

    public void setTransaction(Transaction tx) {
        CURRENT_TX.set(tx);
    }

    public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
        this.requiresTx(false);
        this.setTransaction(transaction);
    }

    private void requiresTx(boolean required) throws SystemException {
        if (this.isTxInFlight() != required) {
            throw new IllegalStateException();
        }
    }

    private boolean isTxInFlight() {
        return CURRENT_TX.get() != null;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.transactionManager.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.requiresTx(true);
        this.getTransaction().setRollbackOnly();
    }

    public void setTransactionTimeout(int i) throws SystemException {
    }

    public Transaction suspend() throws SystemException {
        Transaction transaction = this.getTransaction();
        this.setTransaction(null);
        return transaction;
    }
}

