/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.AxisFilter;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;

final class Normalizer
implements Comparable<Normalizer> {
    private static final String[] EXCLUDES = new String[]{"identifiers"};
    private static final int SHIFT = 2;
    private static final Map<AxisDirection, Integer> ORDER;
    private final CoordinateSystemAxis axis;
    private final DirectionAlongMeridian meridian;
    private final int unitOrder;

    private Normalizer(CoordinateSystemAxis coordinateSystemAxis, int n) {
        this.axis = coordinateSystemAxis;
        this.unitOrder = Units.isAngular((Unit)coordinateSystemAxis.getUnit()) ? n : 0;
        AxisDirection axisDirection = coordinateSystemAxis.getDirection();
        this.meridian = AxisDirections.isUserDefined(axisDirection) ? DirectionAlongMeridian.parse(axisDirection) : null;
    }

    private static int order(AxisDirection axisDirection) {
        Integer n = ORDER.get(axisDirection);
        return n != null ? n : axisDirection.ordinal() << 2;
    }

    @Override
    public int compareTo(Normalizer normalizer) {
        int n = this.unitOrder - normalizer.unitOrder;
        if (n == 0) {
            AxisDirection axisDirection = this.axis.getDirection();
            AxisDirection axisDirection2 = normalizer.axis.getDirection();
            n = AxisDirections.angleForCompass(axisDirection2, axisDirection);
            if (n == Integer.MIN_VALUE) {
                n = this.meridian != null ? (normalizer.meridian != null ? this.meridian.compareTo(normalizer.meridian) : -1) : (normalizer.meridian != null ? 1 : Normalizer.order(axisDirection) - Normalizer.order(axisDirection2));
            }
        }
        return n;
    }

    static boolean sort(CoordinateSystemAxis[] coordinateSystemAxisArray, int n) {
        boolean bl;
        Object[] objectArray = new Normalizer[coordinateSystemAxisArray.length];
        for (bl = false; bl < coordinateSystemAxisArray.length; bl += 1) {
            objectArray[bl] = new Normalizer(coordinateSystemAxisArray[bl], n);
        }
        Arrays.sort(objectArray);
        bl = false;
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = ((Normalizer)objectArray[i]).axis;
            bl |= coordinateSystemAxisArray[i] != coordinateSystemAxis;
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        return bl;
    }

    static CoordinateSystemAxis normalize(CoordinateSystemAxis coordinateSystemAxis, AxisFilter axisFilter) {
        Unit unit = coordinateSystemAxis.getUnit();
        AxisDirection axisDirection = coordinateSystemAxis.getDirection();
        Unit<?> unit2 = axisFilter.getUnitReplacement(coordinateSystemAxis, unit);
        AxisDirection axisDirection2 = axisFilter.getDirectionReplacement(coordinateSystemAxis, axisDirection);
        boolean bl = axisDirection2.equals((Object)axisDirection);
        if (bl && unit2.equals((Object)unit)) {
            return coordinateSystemAxis;
        }
        String string = coordinateSystemAxis.getAbbreviation();
        String string2 = bl ? string : AxisDirections.suggestAbbreviation(coordinateSystemAxis.getName().getCode(), axisDirection2, unit2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        if (string2.equals(string)) {
            hashMap.putAll(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystemAxis, EXCLUDES));
        } else {
            hashMap.put("name", NilReferencingObject.UNNAMED);
        }
        if (bl || axisDirection2.equals((Object)AxisDirections.opposite(axisDirection))) {
            UnitConverter unitConverter;
            try {
                unitConverter = unit.getConverterToAny(unit2);
            }
            catch (IncommensurableException incommensurableException) {
                throw new IllegalStateException(Resources.format((short)26, "axis", unit), incommensurableException);
            }
            double d = unitConverter.convert(coordinateSystemAxis.getMinimumValue());
            double d2 = unitConverter.convert(coordinateSystemAxis.getMaximumValue());
            if (!bl) {
                double d3 = d;
                d = -d2;
                d2 = -d3;
            }
            hashMap.put("minimumValue", d);
            hashMap.put("maximumValue", d2);
            hashMap.put("rangeMeaning", coordinateSystemAxis.getRangeMeaning());
        }
        return new DefaultCoordinateSystemAxis(hashMap, string2, axisDirection2, unit2);
    }

    static AbstractCS normalize(CoordinateSystem coordinateSystem, AxisFilter axisFilter, boolean bl) {
        Object object;
        int n;
        int n2 = coordinateSystem.getDimension();
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            if (axisFilter != null && !axisFilter.accept(coordinateSystemAxis)) continue;
            coordinateSystemAxisArray[n3++] = coordinateSystemAxis;
        }
        Object[] objectArray = Arrays.copyOf(coordinateSystemAxisArray, n3);
        boolean bl2 = false;
        if (axisFilter != null) {
            for (n = 0; n < n3; ++n) {
                objectArray[n] = Normalizer.normalize(objectArray[n], axisFilter);
                bl2 |= objectArray[n] != coordinateSystemAxisArray[n];
            }
        }
        if (bl) {
            n = 0;
            if (coordinateSystem instanceof EllipsoidalCS || coordinateSystem instanceof SphericalCS) {
                n = -1;
            } else if (coordinateSystem instanceof CylindricalCS || coordinateSystem instanceof PolarCS) {
                n = 1;
            }
            bl2 |= Normalizer.sort((CoordinateSystemAxis[])objectArray, n);
            if (n == 1) {
                if (objectArray.length == 3 && Normalizer.isLengthAndAngle((CoordinateSystemAxis[])objectArray, 1)) {
                    ArraysExt.swap((Object[])objectArray, (int)1, (int)2);
                }
                if (AxisDirections.CLOCKWISE.equals((Object)objectArray[1].getDirection()) && Normalizer.isLengthAndAngle((CoordinateSystemAxis[])objectArray, 0)) {
                    ArraysExt.swap((Object[])objectArray, (int)0, (int)1);
                }
            }
        }
        if (!bl2 && n3 == n2) {
            return null;
        }
        for (n = 0; n < n3; ++n) {
            object = objectArray[n];
            if (object.getIdentifiers().isEmpty()) continue;
            for (int i = 0; i < n3; ++i) {
                if (i == n || object != coordinateSystemAxisArray[i]) continue;
                objectArray[n] = Normalizer.forRange(object, object.getMinimumValue(), object.getMaximumValue());
            }
        }
        AbstractCS abstractCS = Normalizer.castOrCopy(coordinateSystem);
        object = (StringBuilder)CharSequences.camelCaseToSentence((CharSequence)abstractCS.getInterface().getSimpleName());
        return abstractCS.createForAxes(Collections.singletonMap("name", AxisDirections.appendTo((StringBuilder)object, (CoordinateSystemAxis[])objectArray)), (CoordinateSystemAxis[])objectArray);
    }

    private static boolean isLengthAndAngle(CoordinateSystemAxis[] coordinateSystemAxisArray, int n) {
        return Units.isLinear((Unit)coordinateSystemAxisArray[n].getUnit()) && Units.isAngular((Unit)coordinateSystemAxisArray[n + 1].getUnit());
    }

    private static AbstractCS shiftAxisRange(CoordinateSystem coordinateSystem) {
        boolean bl = false;
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[coordinateSystem.getDimension()];
        for (int i = 0; i < coordinateSystemAxisArray.length; ++i) {
            double d;
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            if (RangeMeaning.WRAPAROUND.equals((Object)coordinateSystemAxis.getRangeMeaning()) && (d = coordinateSystemAxis.getMinimumValue()) < 0.0) {
                double d2 = coordinateSystemAxis.getMaximumValue();
                double d3 = (d2 - d) / 2.0;
                if ((d -= (d3 *= Math.floor(d / d3 + 1.0E-13))) < (d2 -= d3)) {
                    coordinateSystemAxis = Normalizer.forRange(coordinateSystemAxis, d, d2);
                    bl = true;
                }
            }
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        if (!bl) {
            return null;
        }
        return Normalizer.castOrCopy(coordinateSystem).createForAxes(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystem, EXCLUDES), coordinateSystemAxisArray);
    }

    private static CoordinateSystemAxis forRange(CoordinateSystemAxis coordinateSystemAxis, double d, double d2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(8);
        hashMap.putAll(IdentifiedObjects.getProperties((IdentifiedObject)coordinateSystemAxis, EXCLUDES));
        hashMap.put("minimumValue", d);
        hashMap.put("maximumValue", d2);
        hashMap.put("rangeMeaning", coordinateSystemAxis.getRangeMeaning());
        return new DefaultCoordinateSystemAxis(hashMap, coordinateSystemAxis.getAbbreviation(), coordinateSystemAxis.getDirection(), coordinateSystemAxis.getUnit());
    }

    private static AbstractCS castOrCopy(CoordinateSystem coordinateSystem) {
        return coordinateSystem instanceof AbstractCS ? (AbstractCS)coordinateSystem : AbstractCS.castOrCopy(coordinateSystem);
    }

    static AbstractCS forConvention(CoordinateSystem coordinateSystem, AxesConvention axesConvention) {
        switch (axesConvention) {
            case NORMALIZED: 
            case DISPLAY_ORIENTED: {
                return Normalizer.normalize(coordinateSystem, axesConvention, true);
            }
            case RIGHT_HANDED: {
                return Normalizer.normalize(coordinateSystem, null, true);
            }
            case POSITIVE_RANGE: {
                return Normalizer.shiftAxisRange(coordinateSystem);
            }
        }
        throw new AssertionError(axesConvention);
    }

    static {
        Map<AxisDirection, Integer> map = ORDER = new HashMap<AxisDirection, Integer>();
        int n = AxisDirection.NORTH.ordinal() + 15 << 2;
        map.put(AxisDirections.AWAY_FROM, n + 1);
        map.put(AxisDirections.COUNTER_CLOCKWISE, n + 2);
        map.put(AxisDirections.CLOCKWISE, n + 3);
    }
}

