/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.sax;

import java.util.Vector;
import org.htmlparser.Attribute;
import org.htmlparser.Tag;
import org.xml.sax.helpers.NamespaceSupport;

public class Attributes
implements org.xml.sax.Attributes {
    protected Tag mTag;
    protected NamespaceSupport mSupport;
    protected String[] mParts;
    protected Vector mAttributes;

    public Attributes(Tag tag, NamespaceSupport support, String[] parts) {
        this.mTag = tag;
        this.mSupport = support;
        this.mParts = parts;
        this.mAttributes = null;
    }

    protected Vector getAttributes() {
        if (null == this.mAttributes) {
            this.mAttributes = new Vector();
            Vector attributes = this.mTag.getAttributesEx();
            if (null != attributes) {
                int size = attributes.size();
                for (int i = 1; i < size; ++i) {
                    Attribute attribute = (Attribute)attributes.elementAt(i);
                    String string = attribute.getName();
                    if (null == string) continue;
                    this.mAttributes.add(attribute);
                }
            }
        }
        return this.mAttributes;
    }

    public int getLength() {
        return this.getAttributes().size();
    }

    public String getURI(int index) {
        this.mSupport.processName(this.getQName(index), this.mParts, true);
        return this.mParts[0];
    }

    public String getLocalName(int index) {
        this.mSupport.processName(this.getQName(index), this.mParts, true);
        return this.mParts[1];
    }

    public String getQName(int index) {
        Attribute attribute = (Attribute)this.getAttributes().elementAt(index);
        String ret = attribute.getName();
        return ret;
    }

    public String getType(int index) {
        return "CDATA";
    }

    public String getValue(int index) {
        Attribute attribute = (Attribute)this.getAttributes().elementAt(index);
        String ret = attribute.getValue();
        if (null == ret) {
            ret = "";
        }
        return ret;
    }

    public int getIndex(String uri, String localName) {
        int ret = -1;
        Vector attributes = this.getAttributes();
        int size = attributes.size();
        for (int i = 1; i < size; ++i) {
            Attribute attribute = (Attribute)attributes.elementAt(i);
            String string = attribute.getName();
            this.mSupport.processName(string, this.mParts, true);
            if (!uri.equals(this.mParts[0]) || !localName.equalsIgnoreCase(this.mParts[1])) continue;
            ret = i;
            i = size;
        }
        return ret;
    }

    public int getIndex(String qName) {
        this.mSupport.processName(qName, this.mParts, true);
        return this.getIndex(this.mParts[0], this.mParts[1]);
    }

    public String getType(String uri, String localName) {
        return null;
    }

    public String getType(String qName) {
        return null;
    }

    public String getValue(String uri, String localName) {
        String ret = null;
        int index = this.getIndex(uri, localName);
        if (-1 != index) {
            ret = this.getValue(index);
        }
        return ret;
    }

    public String getValue(String qName) {
        this.mSupport.processName(qName, this.mParts, true);
        return this.getValue(this.mParts[0], this.mParts[1]);
    }
}

