/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collections;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.storage.CoverageQuery;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Query;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.UnsupportedQueryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;

public interface GridCoverageResource
extends DataSet {
    public GridGeometry getGridGeometry() throws DataStoreException;

    public List<SampleDimension> getSampleDimensions() throws DataStoreException;

    default public List<double[]> getResolutions() throws DataStoreException {
        double[] dArray;
        GridGeometry gridGeometry = this.getGridGeometry();
        if (gridGeometry != null && gridGeometry.isDefined(16) && !ArraysExt.allEquals((double[])(dArray = gridGeometry.getResolution(false)), (double)Double.NaN)) {
            return Collections.singletonList(dArray);
        }
        return Collections.emptyList();
    }

    default public GridCoverageResource subset(Query query) throws UnsupportedQueryException, DataStoreException {
        ArgumentChecks.ensureNonNull((String)"query", (Object)query);
        if (query instanceof CoverageQuery) {
            return ((CoverageQuery)query).execute(this);
        }
        throw new UnsupportedQueryException();
    }

    public GridCoverage read(GridGeometry var1, int ... var2) throws DataStoreException;

    default public RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        return RasterLoadingStrategy.AT_READ_TIME;
    }

    default public boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) throws DataStoreException {
        ArgumentChecks.ensureNonNull((String)"strategy", (Object)((Object)rasterLoadingStrategy));
        return rasterLoadingStrategy == this.getLoadingStrategy();
    }
}

