/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.ObjectAlreadyExistsException;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.plugin.SpaceWebNotificationPlugin;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.picocontainer.Startable;

public class SpaceWebNotificationServiceImpl
implements SpaceWebNotificationService,
Startable {
    public static final String APPLICATION_SUB_ITEM_IDS = "applicationSubItemIds";
    public static final String METADATA_TYPE_NAME = "unread";
    private static final Log LOG = ExoLogger.getLogger(SpaceWebNotificationServiceImpl.class);
    private PortalContainer container;
    private MetadataService metadataService;
    private ListenerService listenerService;
    private PluginSettingService pluginSettingService;
    private List<SpaceWebNotificationPlugin> plugins = new ArrayList<SpaceWebNotificationPlugin>();

    public SpaceWebNotificationServiceImpl(PortalContainer container, MetadataService metadataService, PluginSettingService pluginSettingService, ListenerService listenerService) {
        this.container = container;
        this.metadataService = metadataService;
        this.listenerService = listenerService;
        this.pluginSettingService = pluginSettingService;
    }

    public void start() {
        PortalContainer.addInitTask((ServletContext)this.container.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                for (SpaceWebNotificationPlugin spaceWebNotificationPlugin : SpaceWebNotificationServiceImpl.this.plugins) {
                    List notificationPluginIds = spaceWebNotificationPlugin.getNotificationPluginIds();
                    if (!CollectionUtils.isNotEmpty((Collection)notificationPluginIds)) continue;
                    for (String notificationPluginId : notificationPluginIds) {
                        PluginConfig pluginConfig = SpaceWebNotificationServiceImpl.this.pluginSettingService.getPluginConfig(notificationPluginId);
                        if (pluginConfig == null) {
                            LOG.warn("Notification plugin {} wasn't found", new Object[]{notificationPluginId});
                            continue;
                        }
                        pluginConfig.addAdditionalChannel("SPACE_WEB_CHANNEL");
                    }
                }
            }
        });
    }

    public void stop() {
    }

    public void addPlugin(SpaceWebNotificationPlugin spaceWebNotification) {
        this.plugins.add(0, spaceWebNotification);
    }

    public void dispatch(NotificationInfo notification, String username) throws Exception {
        SpaceWebNotificationItem notificationItem = this.getSpaceWebNotificationItem(notification, username);
        if (notificationItem != null) {
            this.markAsUnread(notificationItem);
        }
    }

    public void markAsUnread(SpaceWebNotificationItem notificationItem) throws Exception {
        if (notificationItem == null) {
            throw new IllegalArgumentException("SpaceWebNotificationItem is mandatory");
        }
        if (notificationItem.getSpaceId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.spaceId is mandatory");
        }
        if (notificationItem.getUserId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.userId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationName())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationName is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationItemId())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationItemId is mandatory");
        }
        long userIdentityId = notificationItem.getUserId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(userIdentityId), userIdentityId);
        MetadataObject metadataObject = new MetadataObject(notificationItem.getApplicationName(), notificationItem.getApplicationItemId(), null, notificationItem.getSpaceId());
        try {
            this.mergeExistingUnreadProperties(notificationItem, metadataKey, metadataObject);
            this.metadataService.createMetadataItem(metadataObject, metadataKey, this.toMetadataProperties(notificationItem), userIdentityId);
            this.listenerService.broadcast("notification.unread.item", (Object)notificationItem, (Object)userIdentityId);
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.debug("Object {} already marked as unread", new Object[]{notificationItem});
        }
    }

    public void markAsRead(SpaceWebNotificationItem notificationItem) throws Exception {
        MetadataObject metadataObject;
        if (notificationItem == null) {
            throw new IllegalArgumentException("SpaceWebNotificationItem is mandatory");
        }
        if (notificationItem.getSpaceId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.spaceId is mandatory");
        }
        if (notificationItem.getUserId() <= 0L) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.userId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationName())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationName is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)notificationItem.getApplicationItemId())) {
            throw new IllegalArgumentException("SpaceWebNotificationItem.applicationItemId is mandatory");
        }
        long userIdentityId = notificationItem.getUserId();
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(userIdentityId), userIdentityId);
        List metadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject = new MetadataObject(notificationItem.getApplicationName(), notificationItem.getApplicationItemId(), null, notificationItem.getSpaceId()));
        if (CollectionUtils.isNotEmpty((Collection)metadataItems)) {
            for (MetadataItem metadataItem : metadataItems) {
                this.metadataService.deleteMetadataItem(metadataItem.getId(), true);
            }
            this.listenerService.broadcast("notification.read.item", (Object)notificationItem, (Object)userIdentityId);
        }
    }

    public void markAllAsRead(long userIdentityId, long spaceId) throws Exception {
        if (spaceId <= 0L) {
            throw new IllegalArgumentException("spaceId is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        this.metadataService.deleteByMetadataTypeAndSpaceIdAndCreatorId(METADATA_TYPE_NAME, spaceId, userIdentityId);
        this.listenerService.broadcast("notification.read.allItems", (Object)new SpaceWebNotificationItem(null, null, userIdentityId, spaceId), (Object)userIdentityId);
    }

    public Map<String, Long> countUnreadItemsByApplication(long userIdentityId, long spaceId) {
        return this.metadataService.countMetadataItemsByMetadataTypeAndAudienceId(METADATA_TYPE_NAME, userIdentityId, spaceId);
    }

    private void mergeExistingUnreadProperties(SpaceWebNotificationItem notificationItem, MetadataKey metadataKey, MetadataObject metadataObject) throws ObjectNotFoundException {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject);
        if (CollectionUtils.isNotEmpty((Collection)metadataItems)) {
            for (MetadataItem metadataItem : metadataItems) {
                this.appendNotificationSubItems(notificationItem, metadataItem);
                this.metadataService.deleteMetadataItem(metadataItem.getId(), false);
            }
        }
    }

    private void appendNotificationSubItems(SpaceWebNotificationItem notificationItem, MetadataItem metadataItem) {
        String concatenatedSubItemIds;
        if (MapUtils.isNotEmpty((Map)metadataItem.getProperties()) && StringUtils.isNotBlank((CharSequence)(concatenatedSubItemIds = (String)metadataItem.getProperties().get(APPLICATION_SUB_ITEM_IDS)))) {
            Arrays.stream(StringUtils.split((String)concatenatedSubItemIds, (String)",")).forEach(arg_0 -> ((SpaceWebNotificationItem)notificationItem).addApplicationSubItem(arg_0));
        }
    }

    private Map<String, String> toMetadataProperties(SpaceWebNotificationItem notificationItem) {
        return Collections.singletonMap(APPLICATION_SUB_ITEM_IDS, StringUtils.join((Iterable)notificationItem.getApplicationSubItemIds(), (String)","));
    }

    private SpaceWebNotificationItem getSpaceWebNotificationItem(NotificationInfo notification, String username) {
        SpaceWebNotificationItem spaceApplicationItem;
        SpaceWebNotificationPlugin spaceWebNotification = this.plugins.stream().filter(plugin -> plugin.isManagedPlugin(notification.getKey())).findFirst().orElse(null);
        if (spaceWebNotification != null && (spaceApplicationItem = spaceWebNotification.getSpaceApplicationItem(notification, username)) != null && spaceApplicationItem.getSpaceId() > 0L && spaceApplicationItem.getUserId() > 0L && StringUtils.isNotBlank((CharSequence)spaceApplicationItem.getApplicationItemId()) && StringUtils.isNotBlank((CharSequence)spaceApplicationItem.getApplicationName())) {
            return spaceApplicationItem;
        }
        return null;
    }
}

